/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.trustanchor;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TizenSubCommand(name="info", usage="Show the trust-anchor configuration information.")
public class TrustAnchorInfoCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public int execute() {
        File[] trustAnchorCerts;
        File projectPath = this.getRealWorkingPath();
        this.log.trace("getRealWorkingPath for trust-anchor add: {}", (Object)projectPath.toString());
        Document doc = null;
        String trustAnchorPath = null;
        String rootNodeStr = null;
        String trustAnchorNodeStr = null;
        File manifestFile = new File(projectPath.getAbsolutePath(), "tizen-manifest.xml");
        File configFile = new File(projectPath.getAbsolutePath(), "config.xml");
        if (manifestFile != null && manifestFile.exists()) {
            trustAnchorPath = projectPath + File.separator + "res" + File.separator + ".trust-anchor";
            rootNodeStr = "manifest";
            trustAnchorNodeStr = "trust-anchor";
            doc = XMLUtil.readXML((File)manifestFile);
        } else if (configFile != null && configFile.exists()) {
            trustAnchorPath = projectPath + File.separator + ".trust-anchor";
            rootNodeStr = "widget";
            trustAnchorNodeStr = "tizen:trust-anchor";
            doc = XMLUtil.readXML((File)configFile);
        } else {
            this.progressLog.error("Please input the valid Tizen project.");
            this.log.error("Please input the valid Tizen project.");
            return -1;
        }
        Node trustAnchorNode = XMLUtil.getDOMNodeT((Document)doc, (String[])new String[]{rootNodeStr, trustAnchorNodeStr});
        if (trustAnchorNode == null) {
            this.progressLog.info("Trust-Anchor is disabled for the project {}.", (Object)projectPath.getName());
            return 0;
        }
        String systemCert = ((Element)trustAnchorNode).getAttribute("use-system-certs");
        this.progressLog.info("use-system-certs: " + systemCert);
        String certListStr = "user certificates : ";
        for (File certFile : trustAnchorCerts = new File(trustAnchorPath).listFiles()) {
            certListStr = certListStr + certFile.getName() + ", ";
        }
        this.progressLog.info(certListStr.substring(0, certListStr.length() - 2));
        return 0;
    }
}

