/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DotnetUtil {
    private static final Logger log = LoggerFactory.getLogger(DotnetUtil.class);
    private static final Logger progressLog = LoggerFactory.getLogger((String)"NCLI_PROGRESS");
    public static final String DEFAULT_CONFIGURATION = "Debug";
    public static final String PROJECT_CSPROP_EXTENSION = ".csproj";
    public static final String PROJECT_SLN_EXTENSION = ".sln";
    public static final String PROJECT_JSON_EXTENSION = "project.json";
    public static final String PACKAGES_CONFIG_FILENAME = "packages.config";
    public static final String TIZEN_MANIFEST_FILENAME = "tizen-manifest.xml";
    private static final String TIZEN_CS_TEMPLATE_MANDATORY_GUID = "{2F98DAC9-6F16-457B-AED7-D43CAC379341}";
    public static final String SOLUTION_FOLDER_GUID = "{2150E333-8FDC-42A3-9474-1A3956D46DE8}";
    public static final String CSHARP_GUID = "{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}";

    public static String getWorkingTarget(String workingPath) {
        File workingFile = new File(workingPath);
        if (!workingFile.exists()) {
            return null;
        }
        if (workingFile.isFile()) {
            if (workingPath.endsWith(PROJECT_SLN_EXTENSION) || workingPath.endsWith(PROJECT_CSPROP_EXTENSION)) {
                return workingPath;
            }
        } else if (workingFile.isDirectory()) {
            String slnFilePath = DotnetUtil.findFile(workingPath, PROJECT_SLN_EXTENSION);
            if (slnFilePath == null) {
                return DotnetUtil.findFile(workingPath, PROJECT_CSPROP_EXTENSION);
            }
            return slnFilePath;
        }
        return null;
    }

    public static Set<String> getCSProjectsFromTarget(String targetPath) {
        HashSet<String> csprojTargets;
        block7: {
            if (targetPath == null) {
                return null;
            }
            if (!FileUtil.isExist((String)targetPath)) {
                return null;
            }
            csprojTargets = new HashSet<String>();
            try {
                if (targetPath.endsWith(PROJECT_CSPROP_EXTENSION)) {
                    csprojTargets.add(targetPath);
                    DotnetUtil.getCSProjFromReference(targetPath, csprojTargets);
                    break block7;
                }
                if (targetPath.endsWith(PROJECT_SLN_EXTENSION)) {
                    DotnetUtil.getTizenCSProjFromSlnFile(targetPath, csprojTargets);
                    break block7;
                }
                return null;
            }
            catch (UnexpectedException e) {
                progressLog.error(e.getMessage());
                return null;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                progressLog.error(e.getMessage());
                return null;
            }
        }
        return csprojTargets;
    }

    public static Set<String> getCSProjects(String workingPath) {
        return DotnetUtil.getCSProjectsFromTarget(DotnetUtil.getWorkingTarget(workingPath));
    }

    private static void getCSProjFromReference(String baseProj, Set<String> data) throws IOException {
        File file = new File(baseProj);
        Document menifestDoc = XMLUtil.readXML((File)file);
        NodeList refNodes = XMLUtil.getDOMNodesT((Document)menifestDoc, (String[])new String[]{"Project", "ItemGroup", "ProjectReference"});
        if (refNodes == null) {
            return;
        }
        Node refNode = null;
        String refProj = null;
        for (int i = 0; i < refNodes.getLength(); ++i) {
            refNode = refNodes.item(i);
            refProj = XMLUtil.getDOMValueR((Element)((Element)refNode), (String)"@Include");
            refProj = FileUtil.appendPath((String)file.getParent(), (String)refProj);
            if (!FileUtil.isExist((String)refProj)) {
                String errorMsg = String.format("there is no referred project file %s", refProj);
                throw new UnexpectedException(-3, errorMsg);
            }
            data.add(new File(refProj).getCanonicalPath());
            DotnetUtil.getCSProjFromReference(refProj, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTizenCSProjFromSlnFile(String sln, Set<String> data) throws IOException {
        BufferedReader br = null;
        ArrayList<String> csprojLists = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(Project.)(\"([^\"]*)\").\\s=\\s(\"([^\"]*)\"),\\s(\"([^\"]*)\"),\\s(\"([^\"]*)\")");
        String projectDir = new File(sln).getParent();
        try {
            String s;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(sln)));
            while ((s = br.readLine()) != null) {
                if (!s.startsWith("Project")) continue;
                csprojLists.add(s);
            }
            for (String csProj : csprojLists) {
                String csprojFile;
                String typeGuid;
                Matcher matcher = pattern.matcher(csProj);
                if (!matcher.find() || (typeGuid = matcher.group(3)).equals(SOLUTION_FOLDER_GUID) || !typeGuid.equals(CSHARP_GUID) || (csprojFile = matcher.group(7)) == null) continue;
                File projFile = new File(FileUtil.appendPath((String)projectDir, (String)csprojFile));
                if (projFile.exists()) {
                    data.add(projFile.getCanonicalPath());
                    continue;
                }
                String errorMsg = String.format("there is no project file %s", projFile.getPath());
                throw new UnexpectedException(-3, errorMsg);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private static String findFile(String path, String extension) {
        String slnFilePath = null;
        File dirFile = new File(path);
        File[] children = dirFile.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!child.isFile() || !child.getName().endsWith(extension)) continue;
                if (slnFilePath != null) {
                    return "";
                }
                slnFilePath = child.getAbsolutePath();
            }
        }
        return slnFilePath;
    }

    public static boolean isTizenProject(File projFile) {
        Document menifestDoc;
        String projectTypeGuid;
        return projFile.exists() && (projectTypeGuid = XMLUtil.getDOMValueT((Document)(menifestDoc = XMLUtil.readXML((File)projFile)), (String[])new String[]{"Project", "PropertyGroup", "ProjectTypeGuids"})) != null && projectTypeGuid.contains(TIZEN_CS_TEMPLATE_MANDATORY_GUID);
    }

    public static String getJsonPath(File projectFile) {
        File pdirectory = projectFile.getParentFile();
        File[] files = pdirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(DotnetUtil.PROJECT_JSON_EXTENSION);
            }
        });
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getPackagesConfigPath(File projectFile) {
        File pdirectory = projectFile.getParentFile();
        File[] files = pdirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().equals(DotnetUtil.PACKAGES_CONFIG_FILENAME);
            }
        });
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean existTizenManifest(File projectFile) {
        File pdirectory = projectFile.getParentFile();
        File[] files = pdirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().equals(DotnetUtil.TIZEN_MANIFEST_FILENAME);
            }
        });
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                return true;
            }
        }
        return false;
    }

    public static String getBuildOutputType(String csproj) {
        Document menifestDoc;
        String outputType;
        File projFile = new File(csproj);
        if (projFile.exists() && (outputType = XMLUtil.getDOMValueT((Document)(menifestDoc = XMLUtil.readXML((File)projFile)), (String[])new String[]{"Project", "PropertyGroup", "OutputType"})) != null && !outputType.isEmpty()) {
            return outputType;
        }
        return "";
    }

    public static File getBuildOutputPath(String csproj, String configuration) {
        String targetFramework;
        String buildOutputPath = null;
        File csprojFile = new File(csproj);
        Document menifestDoc = XMLUtil.readXML((File)csprojFile);
        String condition = null;
        Node configNode = null;
        Node configChildNode = null;
        NodeList configNodes = XMLUtil.getDOMNodesT((Document)menifestDoc, (String[])new String[]{"Project", "PropertyGroup"});
        if (configNodes != null) {
            NodeList configChildNodes = null;
            block0: for (int i = 0; i < configNodes.getLength(); ++i) {
                configNode = configNodes.item(i);
                condition = XMLUtil.getDOMValueR((Element)((Element)configNode), (String)"@Condition");
                if (condition == null || !condition.contains(configuration + "|AnyCPU")) continue;
                configChildNodes = configNode.getChildNodes();
                for (int j = 0; j < configChildNodes.getLength(); ++j) {
                    configChildNode = configChildNodes.item(j);
                    if (!configChildNode.getNodeName().equals("OutputPath")) continue;
                    buildOutputPath = configChildNode.getTextContent();
                    break block0;
                }
                break;
            }
        }
        if (buildOutputPath == null) {
            buildOutputPath = FileUtil.appendPath((String)"bin", (String)configuration);
        }
        if ((targetFramework = XMLUtil.getDOMValueT((Document)menifestDoc, (String[])new String[]{"Project", "PropertyGroup", "TargetFramework"})) != null && !targetFramework.isEmpty()) {
            buildOutputPath = FileUtil.appendPath((String)buildOutputPath, (String)targetFramework);
        }
        return new File(FileUtil.appendPath((String)csprojFile.getParent(), (String)buildOutputPath));
    }

    public static File getObjPath(String csproj, String configuration) {
        String objPath = FileUtil.appendPath((String)"obj", (String)configuration);
        File csprojFile = new File(csproj);
        Document menifestDoc = XMLUtil.readXML((File)csprojFile);
        String targetFramework = XMLUtil.getDOMValueT((Document)menifestDoc, (String[])new String[]{"Project", "PropertyGroup", "TargetFramework"});
        if (targetFramework != null && !targetFramework.isEmpty()) {
            objPath = FileUtil.appendPath((String)objPath, (String)targetFramework);
        }
        return new File(FileUtil.appendPath((String)csprojFile.getParent(), (String)objPath));
    }

    public static String getDefaultConfiguration() {
        Configuration config = new Configuration();
        String configuration = config.getValue("default.build.configuration");
        if (configuration == null) {
            configuration = DEFAULT_CONFIGURATION;
        }
        return configuration;
    }
}

