/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.ext.manifest.Account;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrIcon;
import org.tizen.nativecore.misc.editor.UiAttrLocaledName;
import org.tizen.nativecore.misc.editor.dlg.AccountCapabilityEditingSupport;
import org.tizen.nativecore.misc.utils.Constants;

public class UiNewAccountDialog
extends SelectionStatusDialog {
    private Combo fMultipleAccountSupport;
    private Text fProviderId;
    private Text fDefaultLabel;
    private UiAttrIcon fIcon;
    private UiAttrIcon fIconSmall;
    private UiAttrLocaledName fLocaledName;
    private TableViewer fTable;
    private Button fAddBtn;
    private Button fRemoveBtn;
    private Account fAccount;
    protected FormToolkit toolkit;
    protected TizenFormPage fpage;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (UiNewAccountDialog.this.fAccount == null) {
                UiNewAccountDialog.this.fAccount = new Account();
            }
            if (e.widget == UiNewAccountDialog.this.fMultipleAccountSupport) {
                UiNewAccountDialog.this.fAccount.setMultipleAccountSupport(UiNewAccountDialog.this.fMultipleAccountSupport.getText());
            }
            if (e.widget == UiNewAccountDialog.this.fProviderId) {
                UiNewAccountDialog.this.fAccount.setProviderid(UiNewAccountDialog.this.fProviderId.getText());
            }
            if (e.widget == UiNewAccountDialog.this.fDefaultLabel) {
                UiNewAccountDialog.this.fAccount.setDefaultLabel(UiNewAccountDialog.this.fDefaultLabel.getText());
            }
        }
    };

    public UiNewAccountDialog(FormToolkit tk, TizenFormPage page) {
        super(Display.getDefault().getActiveShell());
        this.setTitle("Attributes for Account");
        this.toolkit = tk;
        this.fpage = page;
    }

    public Account getAccount() {
        return this.fAccount;
    }

    public void setAccount(Account fAccount) {
        this.fAccount = fAccount;
    }

    protected Control createDialogArea(Composite parent) {
        Composite grid = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        grid.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 510;
        grid.setLayoutData((Object)gd);
        Composite table = SectionHelper.createTableLayout(grid, this.toolkit, 2);
        this.fMultipleAccountSupport = SectionHelper.createLabelAndCombo(table, this.toolkit, "Multiple account", Constants.BOOLEAN_VALUES, null);
        this.fMultipleAccountSupport.addModifyListener(this.modifyListener);
        this.fProviderId = SectionHelper.createLabelAndText(table, this.toolkit, "Provider ID", "Provider ID of the Account", "");
        this.fProviderId.addModifyListener(this.modifyListener);
        this.fDefaultLabel = SectionHelper.createLabelAndText(table, this.toolkit, "Default label", "Default label for the Account", "");
        this.fDefaultLabel.addModifyListener(this.modifyListener);
        table.setLayoutData((Object)new GridData(4, 4, true, false));
        Group group = new Group(grid, 0);
        group.setText("Icons");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        parent.setBackgroundMode(2);
        Composite icons = SectionHelper.createGridLayout((Composite)group, this.toolkit, 2);
        icons.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fIcon = new UiAttrIcon(this.fpage, true);
        this.fIcon.createUi(icons, this.toolkit, "Icon", false);
        this.fIconSmall = new UiAttrIcon(this.fpage, true);
        this.fIconSmall.createUi(icons, this.toolkit, "Icon small", false);
        this.fLocaledName = new UiAttrLocaledName(this.fpage, false);
        this.fLocaledName.setDefaultLocaleRequired(false);
        this.fLocaledName.createUi(grid, this.toolkit, "Name", false);
        GridData tableGridData = new GridData(4, 1025, true, false);
        Composite titleComposite = this.toolkit.createComposite(grid);
        titleComposite.setLayout((Layout)new GridLayout(2, true));
        titleComposite.setLayoutData((Object)tableGridData);
        Label fTabelDes = new Label(titleComposite, 1024);
        fTabelDes.setText("Capabilities");
        fTabelDes.setBackground(new Color(null, 255, 255, 255));
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 3;
        buttonGridData.grabExcessHorizontalSpace = true;
        Composite buttonsComposite = new Composite(titleComposite, 131072);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)buttonGridData);
        buttonsComposite.setBackground(new Color(null, 255, 255, 255));
        this.fAddBtn = new Button(buttonsComposite, 0x2000000);
        String fAddBtnEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_add_over.png").getFile();
        this.fAddBtn.setBackgroundImage(new Image(null, new ImageData(fAddBtnEnabled)));
        this.fAddBtn.setLayoutData((Object)buttonGridData);
        this.fAddBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Account.AccountCapability created = new Account.AccountCapability(Account.AccountCapability.ACCOUNT_CAPABILITY_PRESETS[0]);
                UiNewAccountDialog.this.fAccount.getCapabilities().add(created);
                UiNewAccountDialog.this.fTable.add((Object)created);
            }
        });
        this.fRemoveBtn = new Button(buttonsComposite, 0x2000000);
        String fRemoveBtnEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_delete_over.png").getFile();
        this.fRemoveBtn.setBackgroundImage(new Image(null, new ImageData(fRemoveBtnEnabled)));
        this.fRemoveBtn.setLayoutData((Object)buttonGridData);
        this.fRemoveBtn.setEnabled(false);
        this.fRemoveBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                IStructuredSelection sel = (IStructuredSelection)UiNewAccountDialog.this.fTable.getSelection();
                Account.AccountCapability cap = (Account.AccountCapability)sel.getFirstElement();
                if (cap != null) {
                    UiNewAccountDialog.this.fAccount.getCapabilities().remove(cap);
                    UiNewAccountDialog.this.fTable.remove((Object)cap);
                }
            }
        });
        Composite tableComposite = this.toolkit.createComposite(grid);
        tableComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        tableComposite.setLayoutData((Object)gd);
        this.fTable = new TableViewer(tableComposite, 68352);
        this.fTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table tableWidget = this.fTable.getTable();
        tableWidget.setHeaderVisible(true);
        tableWidget.setLinesVisible(true);
        tableWidget.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        String[] titles = new String[]{"Capabilities"};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], 100, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Account.AccountCapability)element).getCapabilities();
            }
        });
        col.setEditingSupport((EditingSupport)new AccountCapabilityEditingSupport(col.getViewer(), Account.AccountCapability.ACCOUNT_CAPABILITY_PRESETS));
        this.fTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UiNewAccountDialog.this.updateRemoveButtonStatus();
            }
        });
        this.initialize();
        if (this.fAccount.getCapabilities() != null) {
            this.fTable.setInput((Object)this.fAccount.getCapabilities().toArray());
        }
        return grid;
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fTable, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    protected void updateRemoveButtonStatus() {
        IStructuredSelection sel = (IStructuredSelection)this.fTable.getSelection();
        Account.AccountCapability cap = (Account.AccountCapability)sel.getFirstElement();
        if (cap == null) {
            this.fRemoveBtn.setEnabled(false);
        } else {
            this.fRemoveBtn.setEnabled(true);
        }
    }

    protected void computeResult() {
        if (this.fAccount != null) {
            this.fAccount.setIcon(this.fIcon.getIconInput().getFileName());
            this.fAccount.setIconSmall(this.fIconSmall.getIconInput().getFileName());
            this.fAccount.setNames(this.fLocaledName.getInput());
        }
    }

    private void initialize() {
        if (this.fAccount != null) {
            if (this.fAccount.getMultipleAccountSupport().equals("true")) {
                this.fMultipleAccountSupport.select(0);
            } else {
                this.fMultipleAccountSupport.select(1);
            }
            if (this.fAccount.getProviderid() != null && this.fAccount.getProviderid().length() > 0) {
                this.fProviderId.setText(this.fAccount.getProviderid());
            }
            if (this.fAccount.getDefaultLabel() != null && this.fAccount.getDefaultLabel().length() > 0) {
                this.fDefaultLabel.setText(this.fAccount.getDefaultLabel());
            }
            this.fIcon.setInput(this.fAccount.getIcon());
            this.fIconSmall.setInput(this.fAccount.getIconSmall());
            this.fLocaledName.setInput(this.fAccount.getNames());
        } else {
            this.fAccount = new Account();
            this.fIcon.setInput(new Icon());
            this.fIconSmall.setInput(new Icon());
            this.fLocaledName.setInput(new ArrayList<LocaledValue>());
        }
    }
}

