/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.rm.ui.view;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PluginDropAdapter;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.nativecommon.rm.ui.view.RMTreeContentProvider;
import org.tizen.nativecommon.rm.ui.view.RMTreeLabelProvider;
import org.tizen.nativecommon.rm.ui.view.TizenRMView;

public class RMExpandableLayout {
    private Composite parent;
    private final TizenRMView view;
    private FormToolkit toolkit;
    private Composite mainComp;
    public static final ImageDescriptor ENABLE_ICON = ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/elcl18/switch_folding.png");
    public static final ImageDescriptor DISABLE_ICON = ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/dlcl18/switch_folding.png");
    public static final String DESCIPTION = "";
    public static final String TEXT = "Switch Folding List";
    private Set<Section> sectionItems = new HashSet<Section>();
    private ScrolledForm scrolledForm;
    private Label projectName;
    private Label separator;
    private final String SECTION = "section";
    private final String ITEM = "item";
    private final String TABLE_VIEWER = "tableViewer";
    private TreeViewer currentSelectedViewer;
    private IMenuListener menuListener;
    private IOpenListener openListener;

    public RMExpandableLayout(Composite parent, TizenRMView view) {
        this.parent = parent;
        this.view = view;
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.projectName = new Label(parent, 0);
        this.projectName.setText(view.getProject().getName());
        this.separator = new Label(parent, 258);
        this.separator.setLayoutData((Object)new GridData(768));
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.scrolledForm = this.toolkit.createScrolledForm(parent);
        this.scrolledForm.setExpandHorizontal(true);
        this.scrolledForm.setExpandVertical(true);
        this.scrolledForm.setDragDetect(true);
        this.scrolledForm.getBody().setLayout((Layout)new GridLayout(1, false));
        this.scrolledForm.getBody().setLayoutData((Object)new GridData(1808));
        this.scrolledForm.setLayoutData((Object)new GridData(1808));
        this.scrolledForm.reflow(true);
        this.mainComp = this.toolkit.createComposite(this.scrolledForm.getBody());
        this.mainComp.setDragDetect(true);
        GridLayout gl = new GridLayout(1, false);
        gl.marginBottom = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        this.mainComp.setLayout((Layout)gl);
        this.mainComp.setLayoutData((Object)new GridData(1808));
    }

    private void createSection(ResConfig.Item item) {
        Control control;
        int n;
        int n2;
        Control[] controlArray;
        Section section = this.toolkit.createSection(this.mainComp, 450);
        section.setLayoutData((Object)new GridData(768));
        if (OSChecker.isWindows()) {
            controlArray = section.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                control = controlArray[n];
                if (control instanceof Label) {
                    Label l = (Label)control;
                    l.setData("item", (Object)item);
                    l.addPaintListener((PaintListener)new SectionPaintListener());
                    l.setText("  ");
                }
                ++n;
            }
        } else {
            controlArray = section.getTabList();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                control = controlArray[n];
                if (control instanceof Label) {
                    Label l = (Label)control;
                    l.setData("item", (Object)item);
                    l.addPaintListener((PaintListener)new SectionPaintListener());
                }
                ++n;
            }
        }
        Composite sectionComp = new Composite((Composite)section, 0);
        sectionComp.setDragDetect(true);
        sectionComp.setLayout((Layout)new GridLayout(1, false));
        GridData treeViewerGd = new GridData(1808);
        TreeViewer treeViewer = new TreeViewer(sectionComp, 2);
        treeViewer.getControl().setLayoutData((Object)treeViewerGd);
        treeViewer.setData("section", (Object)section);
        treeViewer.setData("item", (Object)item);
        treeViewer.setContentProvider((IContentProvider)new RMTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new RMTreeLabelProvider());
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        treeViewer.addDropSupport(3, transfers, (DropTargetListener)new PluginDropAdapter((StructuredViewer)treeViewer){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 2;
                super.dragEnter(event);
            }

            public boolean performDrop(Object data) {
                String[] datas;
                ArrayList<String> sourcePathList = new ArrayList<String>();
                ArrayList<String> destPathList = new ArrayList<String>();
                IResource destRes = (IResource)this.getCurrentTarget();
                String destPath = null;
                if (destRes == null) {
                    return false;
                }
                if (1 == destRes.getType()) {
                    destPath = destRes.getParent().getLocation().toOSString();
                } else if (2 == destRes.getType()) {
                    destPath = destRes.getLocation().toOSString();
                } else {
                    return false;
                }
                String[] stringArray = datas = (String[])data;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    String source = stringArray[n2];
                    String fileName = new File(source).getName();
                    String dest = FileUtil.appendPath((String)destPath, (String)fileName);
                    if (this.canCopy(source, dest)) {
                        sourcePathList.add(source);
                        destPathList.add(dest);
                    }
                    ++n2;
                }
                RMExpandableLayout.this.view.createDefaultItem();
                DirectoryCopyHandlingCommand command = new DirectoryCopyHandlingCommand(sourcePathList, destPathList);
                CommonPlugin.getDefault().getExecutor().execute(new Command[]{command});
                try {
                    RMExpandableLayout.this.view.getProject().refreshLocal(2, null);
                }
                catch (CoreException coreException) {}
                return true;
            }

            protected Object determineTarget(DropTargetEvent event) {
                Widget widget = event.item;
                if (widget == null) {
                    TreeViewer viewer = (TreeViewer)this.getViewer();
                    ResConfig.Item item = (ResConfig.Item)viewer.getData("item");
                    if (item != null) {
                        return item.getResource();
                    }
                    return null;
                }
                ResConfig.Key key = (ResConfig.Key)widget.getData();
                return key.getRes();
            }

            private boolean canCopy(String src, String dest) {
                File srcFile = new File(src);
                File destFile = new File(dest);
                while (destFile != null) {
                    if (destFile.equals(srcFile)) {
                        return false;
                    }
                    destFile = destFile.getParentFile();
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                super.validateDrop(target, operation, transferType);
                return true;
            }
        });
        transfers = new Transfer[]{TextTransfer.getInstance(), TemplateTransfer.getInstance(), FileTransfer.getInstance()};
        treeViewer.addDragSupport(3, transfers, (DragSourceListener)new TreeDragSourceEffect(treeViewer.getTree()){

            public void dragStart(DragSourceEvent event) {
                DragSource treeViewer = (DragSource)event.getSource();
                Tree tree = (Tree)treeViewer.getControl();
                Object[] items = tree.getSelection();
                event.doit = !ArrayUtil.isEmpty((Object[])items);
                super.dragStart(event);
            }

            public void dragSetData(DragSourceEvent event) {
                Tree tree = (Tree)this.getControl();
                TreeItem[] selectedItems = tree.getSelection();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String[] fileArray = new String[selectedItems.length];
                    int i = 0;
                    while (i < selectedItems.length) {
                        ResConfig.Key key = (ResConfig.Key)selectedItems[i].getData();
                        fileArray[i] = key.getRes().getLocation().toFile().toString();
                        ++i;
                    }
                    event.data = fileArray;
                } else if (TemplateTransfer.getInstance().isSupportedType(event.dataType)) {
                    TreeItem item = tree.getSelection()[0];
                    ResConfig.Key key = (ResConfig.Key)item.getData();
                    if (key.isKey()) {
                        event.data = key.getKeyString();
                    } else {
                        event.data = null;
                        event.doit = false;
                    }
                } else {
                    TreeItem item = tree.getSelection()[0];
                    ResConfig.Key key = (ResConfig.Key)item.getData();
                    if (key.isKey()) {
                        event.data = String.format("app_resource_manager_get(APP_RESOURCE_TYPE_IMAGE, \"%s\", &res_path);", key.getKeyString());
                    } else {
                        event.data = null;
                        event.doit = false;
                    }
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String[] fileStrings;
                    String[] stringArray = fileStrings = (String[])event.data;
                    int n = fileStrings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileString = stringArray[n2];
                        new File(fileString).delete();
                        ++n2;
                    }
                }
            }
        });
        treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return e1.toString().compareTo(e2.toString());
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RMExpandableLayout.this.currentSelectedViewer = (TreeViewer)event.getSource();
            }
        });
        this.addMenu(treeViewer);
        treeViewer.setInput((Object)item);
        section.setData("tableViewer", (Object)treeViewer);
        section.setData("item", (Object)item);
        section.setClient((Control)sectionComp);
        section.setExpanded(false);
        section.setDragDetect(true);
        this.sectionItems.add(section);
    }

    private void addMenu(TreeViewer treeViewer) {
        MenuManager menuMgr = new MenuManager("Resource Manager MenuMgr");
        menuMgr.setRemoveAllWhenShown(true);
        if (this.menuListener == null) {
            this.menuListener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    for (Object action : RMExpandableLayout.this.view.getActions(RMExpandableLayout.this.getSelectedItem())) {
                        if (action instanceof IAction) {
                            manager.add((IAction)action);
                            continue;
                        }
                        manager.add((IContributionItem)action);
                    }
                }
            };
        }
        menuMgr.addMenuListener(this.menuListener);
        Menu menu = menuMgr.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
        if (this.openListener == null) {
            this.openListener = new IOpenListener(){

                public void open(OpenEvent event) {
                    RMExpandableLayout.this.view.doOpenAction();
                }
            };
        }
        treeViewer.addOpenListener(this.openListener);
    }

    public ResConfig.Item getSelectedItem() {
        if (this.currentSelectedViewer == null) {
            return null;
        }
        return (ResConfig.Item)this.currentSelectedViewer.getData("item");
    }

    public List<ResConfig.Key> getSelectedKeys() {
        ArrayList<ResConfig.Key> selectedKeyList = new ArrayList<ResConfig.Key>();
        if (this.currentSelectedViewer == null) {
            return selectedKeyList;
        }
        TreeItem[] treeItemArray = this.currentSelectedViewer.getTree().getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            selectedKeyList.add((ResConfig.Key)treeItem.getData());
            ++n2;
        }
        return selectedKeyList;
    }

    private void addLists(Set<ResConfig.Item> items) {
        ArrayList<ResConfig.Item> sortedList = new ArrayList<ResConfig.Item>(items);
        Collections.sort(sortedList);
        boolean isExist = false;
        for (ResConfig.Item item : sortedList) {
            isExist = false;
            for (Section section : this.sectionItems) {
                ResConfig.Item sectionItem = (ResConfig.Item)section.getData("item");
                if (!item.equals(sectionItem)) continue;
                section.setData("item", (Object)item);
                isExist = true;
                break;
            }
            if (isExist) continue;
            for (Section section : this.sectionItems) {
                section.dispose();
            }
            this.sectionItems.clear();
            for (ResConfig.Item newItem : sortedList) {
                this.createSection(newItem);
            }
            return;
        }
    }

    private void updateTableViewer() {
        for (Section section : this.sectionItems) {
            TreeViewer viewer = (TreeViewer)section.getData("tableViewer");
            ResConfig.Item item = (ResConfig.Item)section.getData("item");
            viewer.setInput((Object)item);
        }
    }

    private void removeLists(Set<ResConfig.Item> items) {
        boolean isDelete = true;
        ArrayList<Section> removeTabItemList = new ArrayList<Section>();
        for (Section secionItem : this.sectionItems) {
            isDelete = true;
            for (ResConfig.Item item : items) {
                ResConfig.Item oldItem = (ResConfig.Item)secionItem.getData("item");
                if (!oldItem.equals(item)) continue;
                isDelete = false;
                break;
            }
            if (!isDelete) continue;
            removeTabItemList.add(secionItem);
        }
        for (Section sectionItem : removeTabItemList) {
            TreeViewer viewer = (TreeViewer)sectionItem.getData("tableViewer");
            if (viewer != null) {
                viewer.getControl().dispose();
            }
            sectionItem.dispose();
            this.sectionItems.remove(sectionItem);
        }
        if (!removeTabItemList.isEmpty()) {
            this.mainComp.layout();
        }
    }

    public void update(Set<ResConfig.Item> items) {
        this.removeLists(items);
        this.addLists(items);
        this.updateTableViewer();
        this.projectName.setText(this.view.getProject().getName());
        this.mainComp.layout();
        this.scrolledForm.layout();
    }

    public void dispose() {
        this.projectName.dispose();
        this.separator.dispose();
        for (Section section : this.sectionItems) {
            section.dispose();
        }
        this.sectionItems.clear();
        this.mainComp.dispose();
        this.scrolledForm.dispose();
        this.toolkit.dispose();
    }

    class SectionPaintListener
    implements PaintListener {
        SectionPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            ResConfig.Item item = (ResConfig.Item)((Label)e.getSource()).getData("item");
            CompositeImageDescriptor cid = new CompositeImageDescriptor(item){
                Image localeImage;
                Image resolutionImage;
                {
                    this.localeImage = item.getLocaleImage();
                    this.resolutionImage = item.getResolutionImage();
                }

                protected Point getSize() {
                    this.localeImage.getBounds();
                    return new Point(34, 16);
                }

                protected void drawCompositeImage(int arg0, int arg1) {
                    Rectangle r = this.localeImage.getBounds();
                    int y = 8 - r.height / 2;
                    this.drawImage(this.localeImage.getImageData(), 0, y);
                    this.drawImage(this.resolutionImage.getImageData(), 18, 0);
                }
            };
            Image image = cid.createImage();
            if (image != null) {
                gc.fillRectangle(0, 0, image.getImageData().width, image.getImageData().height);
                Point size = ((Label)e.getSource()).getSize();
                String text = "   " + item.getName();
                int stringWidth = gc.stringExtent((String)text).x;
                int width = image.getImageData().width + stringWidth;
                if (size.x != width) {
                    ((Label)e.getSource()).setSize(width, 17);
                }
                gc.drawImage(image, 0, 0, image.getImageData().width, image.getImageData().height, 0, 0, image.getImageData().width, image.getImageData().height);
                gc.drawText(text, image.getImageData().width, 0, true);
            }
        }
    }
}

