/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.sdb.command.FsCommand;
import org.tizen.common.util.AdapterUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.RootJob;
import org.tizen.common.util.SdbCommandUtil;
import org.tizen.nativecommon.ApplicationConfiguration;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ResourceFilterDefines;
import org.tizen.nativecommon.TizenNativeConstants;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.nativecommon.launch.CProjectLaunchCommand;
import org.tizen.nativecommon.launch.CppProjectLaunchCommand;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.resconfig.model.ResConfigHandler;
import org.tizen.nativecommon.rm.model.RMHandler;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.StringUtil;

public class ProjectUtil {
    private static Logger logger = LoggerFactory.getLogger(ProjectUtil.class);
    public static final String CRASH_DIRNAME = "crash-info";
    public static final String FILTER_TPK_DIRECTORY = "*/.tpk";

    private static IProject getProject(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r;
            Object element = objectArray[n2];
            if (element instanceof IAdaptable && (r = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
                return r.getProject();
            }
            ++n2;
        }
        return null;
    }

    public static IProject getProject(Object sourcePart, Object selection) {
        IProject tempProj = null;
        if (selection instanceof IStructuredSelection) {
            tempProj = ProjectUtil.getProject(((IStructuredSelection)selection).toArray());
        }
        if (tempProj == null && sourcePart instanceof IEditorPart) {
            tempProj = ProjectUtil.getProject(new Object[]{((IEditorPart)sourcePart).getEditorInput()});
        }
        if (tempProj == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)tempProj);
        if (info != null) {
            return tempProj;
        }
        return null;
    }

    public static IProject getProject() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editorPart = page.getActiveEditor();
        ISelection selection = page.getSelection();
        return ProjectUtil.getProject(editorPart, selection);
    }

    public static IProject getProject(ILaunchConfiguration config) throws CoreException {
        String projectName;
        IProject proj = null;
        if (config != null && !"".equals(projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", ""))) {
            proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return proj;
    }

    public static IProject getProject(String projectName) {
        IProject proj = null;
        if (projectName != null) {
            proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return proj;
    }

    public static String getArtefactName(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null) {
            IConfiguration configuration = buildInfo.getDefaultConfiguration();
            String artifactName = null;
            if (configuration != null) {
                TizenProjectType type;
                artifactName = configuration.getArtifactName();
                if ("${ProjName}".equals(artifactName)) {
                    artifactName = project.getName();
                }
                if ((type = ProjectUtil.getTizenProjectType(project)) != null && type.isCoreProject()) {
                    return artifactName.toLowerCase();
                }
                return artifactName;
            }
        }
        return null;
    }

    public static IConfiguration getDefaultConfiguration(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null) {
            return buildInfo.getDefaultConfiguration();
        }
        return null;
    }

    public static String getArtifactExtension(IProject project) {
        IConfiguration configuration = ProjectUtil.getDefaultConfiguration(project);
        if (configuration != null) {
            return configuration.getArtifactExtension();
        }
        return null;
    }

    public static String getBinaryPrefix(IProject project) {
        IConfiguration configuration = ProjectUtil.getDefaultConfiguration(project);
        if (configuration != null) {
            String ext = ProjectUtil.getArtifactExtension(project);
            return configuration.getOutputPrefix(ext);
        }
        return null;
    }

    public static String getBuildArchitecture(IProject project) {
        IConfiguration configuration = ProjectUtil.getDefaultConfiguration(project);
        if (configuration != null) {
            return CommonConfigurationManager.getArchitecture(configuration);
        }
        return null;
    }

    public static String getBinaryName(IProject project) {
        return ProjectUtil.getBinaryName(project, true);
    }

    public static String getBinaryName(IProject project, boolean includeExt) {
        String prefix;
        String binary = ProjectUtil.getArtefactName(project);
        if (binary == null) {
            return null;
        }
        String ext = ProjectUtil.getArtifactExtension(project);
        if (ext != null && !ext.isEmpty() && includeExt) {
            binary = binary.concat(".").concat(ext);
        }
        if ((prefix = ProjectUtil.getBinaryPrefix(project)) != null) {
            binary = prefix.concat(binary);
        }
        return binary;
    }

    public static String getExecutableName(ILaunchConfiguration config) throws CoreException {
        IPath exeFile = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        String exename = null;
        exename = exeFile.toFile().getName();
        return exename;
    }

    public static void refreshResources(IProject project) throws CoreException {
        if (!project.isSynchronized(2)) {
            project.refreshLocal(2, null);
        }
    }

    public static String getProjectArtefactType(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return null;
        }
        IConfiguration cfg = info.getDefaultConfiguration();
        if (cfg == null) {
            return null;
        }
        IManagedProject managedProject = cfg.getManagedProject();
        if (managedProject == null) {
            return null;
        }
        IProjectType projectType = managedProject.getProjectType();
        if (projectType == null) {
            return null;
        }
        IBuildPropertyValue buildArtefactType = projectType.getBuildArtefactType();
        if (buildArtefactType == null) {
            return null;
        }
        return buildArtefactType.getId();
    }

    public static TizenProjectType getTizenProjectType(IProject project) {
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        if (manifest != null) {
            return manifest.getNativeProjectType();
        }
        return null;
    }

    public static IProjectLaunchCommand getProjectManifest(IProject project) {
        IProjectLaunchCommand manifest = null;
        manifest = (IProjectLaunchCommand)AdapterUtil.getAdapter((IAdaptable)project, CppProjectLaunchCommand.class);
        if (manifest != null && manifest.getNativeProjectType() != null) {
            return manifest;
        }
        manifest = (IProjectLaunchCommand)AdapterUtil.getAdapter((IAdaptable)project, CProjectLaunchCommand.class);
        if (manifest == null || manifest.getNativeProjectType() == null) {
            return null;
        }
        return manifest;
    }

    public static boolean enableAutoBuild(boolean enable) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != enable) {
            desc.setAutoBuilding(enable);
            workspace.setDescription(desc);
        }
        return isAutoBuilding;
    }

    public static void enableProjectAutoBuild(IProject project, boolean enable) throws CoreException {
        if (project == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration cfg = info.getDefaultConfiguration();
        if (cfg == null) {
            return;
        }
        IBuilder bldr = cfg.getEditableBuilder();
        bldr.setAutoBuildEnable(enable);
        bldr.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_AUTO, "all");
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    public static IXMLStore getXmlStore(IProject project) {
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        if (manifest == null) {
            return null;
        }
        return manifest.getXmlStore();
    }

    public static IXMLStore getXmlStore(IProject project, String loadClassId) {
        IXMLStore xmlManager = null;
        try {
            xmlManager = (IXMLStore)PluginUtil.loadClass((String)"org.tizen.nativecommon.store", (String)loadClassId);
            if (xmlManager == null) {
                throw new IllegalArgumentException("There is no plug-in extending org.tizen.nativecommon.store");
            }
            xmlManager.setProject(project);
            xmlManager.loadXml();
        }
        catch (CoreException e) {
            logger.error("Exception occurred while creating class (extension point: org.tizen.nativecommon.store, class ID: " + loadClassId, (Throwable)e);
        }
        return xmlManager;
    }

    public static String getLaunchConfigurationName(IProject project) {
        String configName = project.getName();
        if (ManagedBuildManager.getBuildInfo((IResource)project) != null) {
            configName = NLS.bind((String)TizenLaunchMessages.TizenMainTab_Configuration_name, (Object)ProjectUtil.getArtefactName(project), (Object)ProjectUtil.getDefaultConfiguration(project));
        }
        return configName;
    }

    public static boolean isApplicationProject(IProject project) {
        TizenProjectType prjType = ProjectUtil.getTizenProjectType(project);
        return prjType == null ? false : prjType.isNativeApplicationProject();
    }

    public static boolean isSharedLibraryProject(IProject project) {
        TizenProjectType prjType = ProjectUtil.getTizenProjectType(project);
        return prjType == null ? false : prjType.isNativeSharedLibraryProject();
    }

    public static boolean containsLibraryProject(IProject[] projects) {
        if (projects == null || projects.length <= 0) {
            return false;
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (ProjectUtil.isLibraryProject(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isStaticLibraryProject(IProject project) {
        TizenProjectType prjType = ProjectUtil.getTizenProjectType(project);
        return prjType == null ? false : prjType.isNativeStaticLibraryProject();
    }

    public static boolean isLibraryProject(IProject project) {
        if (project == null) {
            return false;
        }
        return ProjectUtil.isSharedLibraryProject(project) || ProjectUtil.isStaticLibraryProject(project);
    }

    public static boolean hasReferencedLibraryProject(IProject project) throws CoreException {
        if (project == null) {
            return false;
        }
        IProject[] referencedProjects = project.getReferencedProjects();
        if (referencedProjects == null || referencedProjects.length <= 0) {
            return false;
        }
        IProject[] iProjectArray = referencedProjects;
        int n = referencedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            if (ProjectUtil.isLibraryProject(refProject)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDebuggableProject(IProject project) {
        TizenProjectType prjType = ProjectUtil.getTizenProjectType(project);
        return prjType == null ? false : prjType.isNativeDebuggableProject();
    }

    public static IProject searchProject(String appid) {
        IProject project = null;
        if (appid != null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ApplicationConfiguration config = null;
            String tmpId = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                config = new ApplicationConfiguration(proj);
                tmpId = config.getAppId();
                if (appid.equals(tmpId)) {
                    project = proj;
                    break;
                }
                int idxSub = tmpId.lastIndexOf(".");
                String lastSegementOfAppid = tmpId.substring(idxSub + 1, tmpId.length()).trim();
                if (appid.equals(lastSegementOfAppid)) {
                    project = proj;
                    break;
                }
                ++n2;
            }
        }
        return project;
    }

    public static String pullCSFile(IDevice device, String remoteCSPath) throws CoreException, IOException {
        String csLocalPath = null;
        String appid = "";
        if (remoteCSPath != null) {
            String csFile = FilenameUtil.getFilename((String)remoteCSPath);
            appid = ProjectUtil.getAppId(csFile);
            if (appid != null) {
                csLocalPath = ProjectUtil.pullAndGetPath(csFile, appid, device, remoteCSPath);
            } else {
                logger.error("Failed to search a project: " + appid);
            }
        } else {
            logger.error("Failed to get app id from file name: " + remoteCSPath);
        }
        ProjectUtil.checkArchiveFile(device, remoteCSPath);
        return csLocalPath;
    }

    private static String pullAndGetPath(String csFile, String appid, IDevice device, String remoteCSPath) throws CoreException, IOException {
        String csLocalPath = null;
        IProject project = ProjectUtil.searchProject(appid);
        if (project != null) {
            IFolder folder = project.getFolder(CRASH_DIRNAME);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            String csLocalDirPath = folder.getLocation().toOSString();
            csLocalPath = String.valueOf(csLocalDirPath) + File.separatorChar + csFile;
            SyncService syncService = null;
            try {
                syncService = device.getSyncService();
                SyncResult result = syncService.pull(device.getFileEntry(remoteCSPath), csLocalDirPath);
                if (result.isOk()) {
                    ProjectUtil.refreshResources(project);
                    logger.info("Downloaded cs file: " + csLocalPath);
                } else {
                    logger.error("Failed to pull file: " + csFile);
                }
            }
            finally {
                IOUtil.tryClose((Closeable)syncService);
            }
        }
        return csLocalPath;
    }

    private static void checkArchiveFile(IDevice device, String remoteCSPath) {
        boolean isZipExtension = "zip".equals(FilenameUtil.getExtension((String)remoteCSPath));
        String fileName = FilenameUtil.getFilename((String)remoteCSPath);
        String CSName = fileName.substring(0, fileName.indexOf(46)).trim();
        String CSPath = remoteCSPath.substring(0, remoteCSPath.lastIndexOf(47) + 1).trim();
        String zipFilePath = String.valueOf(CSPath) + CSName + ".zip";
        String infoFilePathinZip = String.valueOf(CSName) + "/" + CSName + ".info";
        String extractInfoFilePath = String.valueOf(CSPath) + CSName + ".info";
        if (isZipExtension) {
            class InstallJob
            implements RootJob {
                private boolean isSuccess = false;
                private final /* synthetic */ IDevice val$device;
                private final /* synthetic */ String val$zipFilePath;
                private final /* synthetic */ String val$infoFilePathinZip;
                private final /* synthetic */ String val$extractInfoFilePath;

                InstallJob(IDevice iDevice, String string, String string2, String string3) {
                    this.val$device = iDevice;
                    this.val$zipFilePath = string;
                    this.val$infoFilePathinZip = string2;
                    this.val$extractInfoFilePath = string3;
                }

                public void run() {
                    FsCommand command = new FsCommand(this.val$device, null);
                    try {
                        this.isSuccess = command.unzipCOptionAndCreateFile(this.val$zipFilePath, this.val$infoFilePathinZip, this.val$extractInfoFilePath);
                    }
                    catch (Exception exception) {
                        this.isSuccess = false;
                        return;
                    }
                }

                public boolean isSuccess() {
                    return this.isSuccess;
                }
            }
            InstallJob installJob = new InstallJob(device, zipFilePath, infoFilePathinZip, extractInfoFilePath);
            SdbCommandUtil.runCommandOnRoot((IDevice)device, (RootJob)installJob);
        }
    }

    public static String getAppId(String csPath) {
        String appid = null;
        if (csPath != null) {
            int s;
            if ("cs".equals(FilenameUtil.getExtension((String)csPath))) {
                int s2 = csPath.indexOf("_");
                if (s2 > 0) {
                    appid = csPath.substring(0, s2);
                }
            } else if ("info".equals(FilenameUtil.getExtension((String)csPath)) && (s = csPath.indexOf("_")) > 0) {
                appid = csPath.substring(0, s);
            }
        }
        return appid;
    }

    public static String getAppId(IProject project) {
        IXMLStore xmlManager;
        try {
            xmlManager = ProjectUtil.getXmlStore(project);
        }
        catch (Exception e) {
            logger.debug("Failed to get xml manager", (Throwable)e);
            return null;
        }
        String appId = null;
        if (xmlManager != null) {
            appId = xmlManager.getXMLDataId();
        }
        return appId;
    }

    @Deprecated
    public static boolean addFilter(IProject project, String pattern) {
        if (project == null || pattern == null) {
            return false;
        }
        FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
        argument.key = FileInfoAttributesMatcher.KEY_PROPJECT_RELATIVE_PATH;
        argument.operator = FileInfoAttributesMatcher.OPERATOR_MATCHES;
        argument.pattern = pattern;
        int type = 26;
        FileInfoMatcherDescription matcherDes = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)FileInfoAttributesMatcher.encodeArguments((FileInfoAttributesMatcher.Argument)argument));
        try {
            project.createFilter(type, matcherDes, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            logger.error("Cannot add resource filter", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean addFilter(IProject project, ResourceFilterDefines define) {
        if (project == null || define == null) {
            return false;
        }
        FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
        argument.key = define.getKey();
        argument.operator = define.getOperator();
        argument.pattern = define.getPattern();
        int type = define.getType();
        FileInfoMatcherDescription matcherDes = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)FileInfoAttributesMatcher.encodeArguments((FileInfoAttributesMatcher.Argument)argument));
        try {
            project.createFilter(type, matcherDes, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            logger.error("Cannot add resource filter", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getPackageFileName(IProject project, String ext) {
        IXMLStore xmlStore = ProjectUtil.getXmlStore(project);
        if (xmlStore == null) {
            logger.error("Failed to get xmlStore: " + project);
            return "";
        }
        String pkgId = xmlStore.getPkgId();
        String version = xmlStore.getVersion();
        String arch = ProjectUtil.getArchitectureName(project);
        if (StringUtil.isEmpty((CharSequence)arch)) {
            return "";
        }
        return String.format("%s-%s-%s.%s", pkgId, version, arch, ext);
    }

    public static String getArchitectureName(IProject project) {
        String arch;
        IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
        SmartBuildInterface sbi = SmartBuildInterface.getInstance(project);
        String targetId = CommonConfigurationManager.getBuildTargetName(config);
        try {
            arch = sbi.getRootstrapArchitecture(targetId);
            arch = arch != null ? (arch.equals("armel") ? "arm" : arch) : "";
        }
        catch (SBIException e) {
            logger.error("Cannot find architecture in targetId", (Throwable)e);
            return "";
        }
        return arch;
    }

    public static String getAppDirectory(IProject project, IDevice device) {
        String appId = ProjectUtil.getAppId(project);
        if (appId == null) {
            return "";
        }
        return String.valueOf(device.getAppInstallPath()) + "/" + appId;
    }

    public static String getAppTmpDirectory(IProject project, IDevice device) {
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        if (manifest == null) {
            return "";
        }
        return String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)device)) + "/" + manifest.getPackageName();
    }

    public static String getRootTmpDirectory(IProject project) {
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        if (manifest == null) {
            return "";
        }
        return String.valueOf(TizenPlatformConstants.TEMPORARY_DIR_PATH) + "/" + manifest.getPackageName();
    }

    public static File findPackageFile(IDevice currentDevice, File searchPath, String ext, IProject project) {
        String packageFileName = ProjectUtil.getPackageFileName(project, ext);
        if (StringUtil.isEmpty((CharSequence)packageFileName)) {
            return null;
        }
        String arch = ProjectUtil.getArchitectureName(project);
        if (!LaunchUtils.isSameArch(currentDevice, arch)) {
            logger.error("Archtecture of %d and %s is not same", (Object)packageFileName, (Object)currentDevice.toString());
            return null;
        }
        String projectFullPath = "";
        try {
            projectFullPath = String.valueOf(FilenameUtil.getCanonicalPath((File)project.getLocation().toFile())) + "/";
        }
        catch (IOException e) {
            logger.error("Failed to get project's canonical path", (Throwable)e);
            return null;
        }
        String packageFileFullPath = String.valueOf(projectFullPath) + ProjectUtil.getDefaultConfiguration(project).getName() + "/" + packageFileName;
        packageFileFullPath = ProjectUtil.modifyArchitecture(packageFileFullPath);
        File packageFile = new File(packageFileFullPath);
        return packageFile.exists() ? packageFile : null;
    }

    public static String modifyArchitecture(String target) {
        String[][] stringArray = SBIModel.ARCHITECTURES;
        int n = SBIModel.ARCHITECTURES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] archGroup;
            String[] stringArray2 = archGroup = stringArray[n2];
            int n3 = archGroup.length;
            int n4 = 0;
            while (n4 < n3) {
                String archItem = stringArray2[n4];
                if (target.contains(archItem)) {
                    return target.replace(archItem, archGroup[0]);
                }
                ++n4;
            }
            ++n2;
        }
        return target;
    }

    public static File findTEPPackageFile(IProject project) {
        if (project == null) {
            return null;
        }
        IPath projLoc = project.getLocation();
        IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
        if (config == null) {
            return null;
        }
        String configName = config.getName();
        IPath buildDir = projLoc.append(configName);
        File buildDirFile = buildDir.toFile();
        IXMLStore xmlStore = ProjectUtil.getXmlStore(project);
        if (xmlStore == null) {
            logger.error("Failed to get xmlStore: " + project);
            return null;
        }
        String pkgId = xmlStore.getPkgId();
        File[] listFiles = buildDirFile.listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File cFile = fileArray[n2];
                String fileName = cFile.getName();
                if (fileName.startsWith(pkgId) && fileName.endsWith(TizenNativeConstants.PKG_TEP_EXTENSION)) {
                    return cFile;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isLlvmToolchain(IProject project) {
        try {
            IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
            String targetId = CommonConfigurationManager.getBuildTargetName(config);
            String toolchainId = SmartBuildInterface.getInstance().getToolchainIDFromTargetID(targetId);
            toolchainId = toolchainId.toLowerCase();
            return toolchainId.contains("llvm");
        }
        catch (Throwable throwable) {
            logger.debug("Failed to check whether the project's toolchain is set with LLVM");
            return false;
        }
    }

    public static void generateResMetaFile(IProject project) {
        if (!RMHandler.isSupportedProject(project)) {
            return;
        }
        ResConfigHandler handler = new ResConfigHandler(project);
        ResConfig resConfig = new ResConfig(project);
        ResConfig.Item defaultItem = resConfig.getDefaultImage();
        IResource defaultRes = defaultItem.getResource();
        if (defaultRes != null && defaultRes.exists()) {
            handler.marshal(new ResConfig(project));
        } else {
            handler.removeResFile();
        }
    }

    public static void generateResMetaFile(IProject project, String location) {
        if (!RMHandler.isSupportedProject(project)) {
            return;
        }
        ResConfigHandler handler = new ResConfigHandler(project);
        ResConfig resConfig = new ResConfig(project, location);
        ResConfig.Item defaultItem = resConfig.getDefaultImage();
        IResource defaultRes = defaultItem.getResource();
        if (defaultRes != null && defaultRes.exists()) {
            handler.marshal(resConfig, location);
        } else {
            handler.removeResFile();
        }
    }

    public static IProject getProject(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof ITreeSelection)) {
            return null;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        TreePath[] treePaths = treeSelection.getPaths();
        Object firstSegment = treePaths[0].getFirstSegment();
        if (firstSegment instanceof IProject) {
            return (IProject)firstSegment;
        }
        return null;
    }
}

