/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.dialog;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.page.PackageManagerMainWindow;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class NotifierDialog {
    private WizardUIResourceHandler uiRsrcHandler;
    private final int DISPLAY_TIME = 5000;
    private final int FADE_TIMER = 50;
    private final int FADE_IN_STEP = 30;
    private final int FADE_OUT_STEP = 4;
    private final int FINAL_ALPHA = 225;
    private int DIALOG_WIDTH = 0;
    private int DIALOG_HEIGHT = 0;
    private int START_LOCATION_MARGIN = 0;
    private Color titleColor;
    private Color fgColor;
    private Color bgTopGradient;
    private Color bgBottomGradient;
    private Color borderColor;
    private static List<Shell> activeShells = new ArrayList<Shell>();
    private static List<NotiType> activeNotiTypes = new ArrayList<NotiType>();
    private Image oldImage;
    private Image bgIconImage;
    private Shell shell;
    private Shell parentShell;
    private static int startX = 0;
    private static int startY = 0;
    private ViewController viewController;

    public NotifierDialog(ViewController viewController, Shell parent) {
        this.viewController = viewController;
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        this.titleColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_TOAST_TITLE_FOREGROUND);
        this.fgColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_TOAST_TEXT_FOREGROUND);
        this.bgTopGradient = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_TOAST_BG_TOP_GRADIENT);
        this.bgBottomGradient = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_TOAST_BG_BOTTOM_GRADIENT);
        this.borderColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_TOAST_BORDER);
        this.parentShell = parent;
        this.initSize();
    }

    private void initSize() {
        Rectangle size = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_NOTI_DAILOG_AREA);
        this.DIALOG_WIDTH = size.width;
        this.DIALOG_HEIGHT = size.height;
        size = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_NOTI_DAILOG_LOCATION_MARGIN);
        this.START_LOCATION_MARGIN = size.y;
    }

    public void notify(String title, String message, NotiType type, Component component) {
        this.notify(title, message, type);
    }

    public void notify(String title, String message, final NotiType type) {
        boolean isDisappear = true;
        this.shell = new Shell(Display.getDefault(), 540680);
        this.shell.setLayout(new FillLayout());
        this.shell.setForeground(this.fgColor);
        this.shell.setBackgroundMode(1);
        this.shell.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.widget instanceof Shell) {
                    Shell shell = (Shell)event.widget;
                    activeNotiTypes.remove(activeShells.indexOf(shell));
                    activeShells.remove(shell);
                }
            }
        });
        this.bgIconImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_NOTIFY_BG);
        this.shell.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event e) {
                try {
                    Rectangle rect = NotifierDialog.this.shell.getClientArea();
                    Image newImage = new Image((Device)Display.getDefault(), Math.max(1, rect.width), rect.height);
                    GC gc = new GC(newImage);
                    gc.setLineWidth(1);
                    gc.setForeground(NotifierDialog.this.borderColor);
                    gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    gc.setForeground(NotifierDialog.this.bgTopGradient);
                    gc.setBackground(NotifierDialog.this.bgBottomGradient);
                    gc.fillGradientRectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2, true);
                    Rectangle size = NotifierDialog.this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_NOTI_DAILOG_BG_IMAGE);
                    gc.drawImage(NotifierDialog.this.bgIconImage, size.x, size.y);
                    gc.dispose();
                    NotifierDialog.this.shell.setBackgroundImage(newImage);
                    if (NotifierDialog.this.oldImage != null) {
                        NotifierDialog.this.oldImage.dispose();
                    }
                    NotifierDialog.this.oldImage = newImage;
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
        Composite inner = new Composite(this.shell, 0);
        inner.setLayoutData(new GridData());
        GridLayout gl = new GridLayout(1, false);
        Rectangle size = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_NOTI_DAILOG_INNER_MARGIN);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = size.x;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        gl.verticalSpacing = size.width;
        inner.setLayout(gl);
        inner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                NotifierDialog.this.parentShell.setActive();
            }
        });
        Cursor fCursor = new Cursor(Display.getDefault(), 0);
        StyledText titleText = new StyledText(inner, 0);
        StyleRange titleStyle = new StyleRange();
        titleText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        String filteredTitle = this.getAllignedLongText(title, titleText);
        titleStyle.start = 0;
        titleStyle.length = filteredTitle.length();
        titleStyle.foreground = this.titleColor;
        GridData titleTextGridData = new GridData(16384, 1024, true, true, 0, 0);
        titleText.setDoubleClickEnabled(false);
        titleText.setEditable(false);
        titleText.setBlockSelection(false);
        titleText.setCursor(fCursor);
        titleText.setText(filteredTitle);
        titleText.setLayoutData(titleTextGridData);
        titleText.setStyleRange(titleStyle);
        titleText.setCaret(null);
        final StyledText clickText = new StyledText(inner, 66);
        StyleRange clickTextStyle = new StyleRange();
        clickText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        clickTextStyle.start = 0;
        clickTextStyle.length = message.length();
        if (type == NotiType.CANCEL || type == NotiType.FAIL || type == NotiType.GROUPFAIL) {
            clickTextStyle.underline = true;
            clickTextStyle.underlineStyle = 4;
            isDisappear = false;
        }
        clickTextStyle.foreground = this.fgColor;
        GridData clickTextGridData = new GridData(16384, 128, true, true, 0, 0);
        clickText.setDoubleClickEnabled(false);
        clickText.setEditable(false);
        clickText.setBlockSelection(false);
        clickText.setCursor(fCursor);
        clickText.setText(message);
        clickText.setLayoutData(clickTextGridData);
        clickText.setStyleRange(clickTextStyle);
        clickText.setCaret(null);
        clickText.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event event) {
                try {
                    int offset = clickText.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange style = clickText.getStyleRangeAtOffset(offset);
                    if (style != null && style.underline && style.underlineStyle == 4 && (type == NotiType.CANCEL || type == NotiType.FAIL || type == NotiType.GROUPFAIL)) {
                        this.moveProgressTab();
                        NotifierDialog.this.parentShell.setFocus();
                        NotifierDialog.this.parentShell.setVisible(true);
                        NotifierDialog.this.shell.dispose();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            private void moveProgressTab() {
                if (NotifierDialog.this.viewController != null) {
                    PackageManagerMainWindow.getPackageManagerWindow().tabRedraw(PackageManagerMainWindow.TabViewType.PROGRESS);
                    NotifierDialog.this.viewController.enablePages(PackageManagerMainWindow.TabViewType.PROGRESS);
                }
            }
        });
        this.shell.setSize(this.DIALOG_WIDTH, this.DIALOG_HEIGHT);
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        if (PlatformUtil.isMacOS()) {
            startX = bounds.width - this.DIALOG_WIDTH;
            startY = 0;
        } else if (PlatformUtil.isLinux()) {
            startX = bounds.width - this.DIALOG_WIDTH;
            startY = this.START_LOCATION_MARGIN;
        } else {
            startX = bounds.width - this.DIALOG_WIDTH;
            int taskBarHeight = Toolkit.getDefaultToolkit().getScreenSize().height - GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height;
            startY = bounds.height - this.DIALOG_HEIGHT - taskBarHeight;
        }
        if (!activeShells.isEmpty()) {
            ArrayList<Shell> modifiable = new ArrayList<Shell>(activeShells);
            Collections.reverse(modifiable);
            for (Shell shell : modifiable) {
                NotiType tmpType = activeNotiTypes.get(activeShells.indexOf(shell));
                if (tmpType == NotiType.CANCEL || tmpType == NotiType.FAIL || tmpType == NotiType.GROUPFAIL) {
                    shell.dispose();
                    continue;
                }
                Point curLoc = shell.getLocation();
                if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
                    shell.setLocation(curLoc.x, curLoc.y + this.DIALOG_HEIGHT + 2);
                    if (curLoc.y + this.DIALOG_HEIGHT + 2 >= 0) continue;
                    shell.dispose();
                    continue;
                }
                if (!PlatformUtil.isWindows()) continue;
                shell.setLocation(curLoc.x, curLoc.y - this.DIALOG_HEIGHT - 2);
                if (curLoc.y - this.DIALOG_HEIGHT - 2 >= 0) continue;
                shell.dispose();
            }
        }
        this.shell.setLocation(startX, startY);
        this.shell.setVisible(true);
        activeShells.add(this.shell);
        activeNotiTypes.add(activeShells.indexOf(this.shell), type);
        if (isDisappear) {
            this.startTimer(this.shell);
        }
    }

    private String getAllignedLongText(String origText, Composite parent) {
        String alignedText = origText;
        GC gc = new GC(parent);
        int textWidth = gc.textExtent((String)alignedText).x;
        while (textWidth > 230) {
            alignedText = alignedText.contains("...") ? alignedText.substring(0, alignedText.length() - 4) + "..." : alignedText.substring(0, alignedText.length() - 1) + "...";
            textWidth = gc.textExtent((String)alignedText).x;
        }
        gc.dispose();
        return alignedText;
    }

    private void startTimer(final Shell shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    NotifierDialog.this.fadeOut(shell);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(5000, run);
    }

    private void fadeOut(final Shell shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int cur = shell.getAlpha();
                    if ((cur -= 4) <= 0) {
                        if (NotifierDialog.this.oldImage != null) {
                            NotifierDialog.this.oldImage.dispose();
                        }
                        shell.dispose();
                        return;
                    }
                    shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, run);
    }

    public static enum NotiType {
        SUCCESS,
        FAIL,
        GROUPFAIL,
        CANCEL;

        private Image image;

        public Image getImage() {
            return this.image;
        }
    }
}

