/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return false;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean bl;
        long l;
        long l2;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l3 = OS.gtk_font_selection_dialog_new(byArray);
        if (this.parent != null) {
            l2 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l3, l2);
            l = OS.gtk_window_get_icon_list(l2);
            if (l != 0L) {
                OS.gtk_window_set_icon_list(l3, l);
                OS.g_list_free(l);
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            l2 = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(l2, l3);
        }
        OS.gtk_window_set_modal(l3, true);
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            long l4 = OS.pango_font_description_to_string(font.handle);
            int n = OS.strlen(l4);
            byte[] byArray2 = new byte[n + 1];
            OS.memmove(byArray2, l4, (long)n);
            font.dispose();
            OS.g_free(l4);
            OS.gtk_font_selection_dialog_set_font_name(l3, byArray2);
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l3)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l3, 0L);
        }
        int n2 = OS.gtk_dialog_run(l3);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l);
        }
        if (OS.gtk_window_get_modal(l3)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n2 == -5;
        if (bl) {
            long l5 = OS.gtk_font_selection_dialog_get_font_name(l3);
            int n3 = OS.strlen(l5);
            byte[] byArray3 = new byte[n3 + 1];
            OS.memmove(byArray3, l5, (long)n3);
            OS.g_free(l5);
            long l6 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new(display, l6);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(l6);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l3);
        if (!bl) {
            return null;
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean bl) {
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

