/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.tizen.library.sdkutils.util.Log;

public class ContentEditUtil {
    public static boolean replaceContent(File file, String keyName, String keyValue) {
        return ContentEditUtil.replaceContent(file, keyName, keyValue, "=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceContent(File file, String keyName, String keyValue, String delimiter) {
        boolean result = false;
        File rfile = file;
        File wfile = new File(file.toString() + ".bak");
        if (!rfile.exists()) {
            return result;
        }
        if (wfile.exists()) {
            wfile.delete();
        }
        try {
            wfile.createNewFile();
        }
        catch (IOException e1) {
            Log.catching(e1);
            Log.debug("A file cannot be create: " + wfile.toString());
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter wr = null;
        FileLock fl = null;
        try {
            String readLine;
            fis = new FileInputStream(rfile);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            fos = new FileOutputStream(wfile);
            fl = fos.getChannel().tryLock();
            osr = new OutputStreamWriter(fos);
            wr = new BufferedWriter(osr);
            while ((readLine = br.readLine()) != null) {
                String writeLine;
                if (readLine.contains(keyName)) {
                    writeLine = new String(readLine);
                    int startChar = readLine.indexOf(delimiter);
                    if (startChar == -1) break;
                    String str = readLine.substring(startChar + 1);
                    writeLine = writeLine.replace(str, keyValue);
                    wr.write(writeLine);
                    wr.newLine();
                    result = true;
                    continue;
                }
                writeLine = readLine;
                wr.write(writeLine);
                wr.newLine();
            }
            if (fl != null) {
                fl.release();
            }
        }
        catch (IOException ioe) {
            Log.catching(ioe);
            result = false;
        }
        catch (OverlappingFileLockException ofe) {
            Log.catching(ofe);
            result = false;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (osr != null) {
                try {
                    osr.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
        }
        rfile.delete();
        wfile.renameTo(rfile);
        return result;
    }

    public static boolean addContent(File file, String keyName, String keyValue) {
        return ContentEditUtil.addContent(file, keyName, keyValue, "=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addContent(File file, String keyName, String keyValue, String delimiter) {
        boolean result = false;
        File rfile = file;
        File wfile = new File(file.toString() + ".bak");
        if (!rfile.exists()) {
            return result;
        }
        if (wfile.exists()) {
            wfile.delete();
        }
        try {
            wfile.createNewFile();
        }
        catch (IOException e1) {
            Log.catching(e1);
            Log.debug("A file cannot be create: " + wfile.toString());
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter wr = null;
        FileLock fl = null;
        try {
            String writeLine;
            String readLine;
            fis = new FileInputStream(rfile);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            fos = new FileOutputStream(wfile);
            fl = fos.getChannel().tryLock();
            osr = new OutputStreamWriter(fos);
            wr = new BufferedWriter(osr);
            while ((readLine = br.readLine()) != null) {
                writeLine = readLine;
                wr.write(writeLine);
                wr.newLine();
            }
            writeLine = keyName + delimiter + keyValue;
            wr.write(writeLine);
            wr.newLine();
            if (fl != null) {
                fl.release();
            }
        }
        catch (IOException ioe) {
            Log.catching(ioe);
            result = false;
        }
        catch (OverlappingFileLockException ofe) {
            Log.catching(ofe);
            result = false;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (osr != null) {
                try {
                    osr.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
        }
        rfile.delete();
        wfile.renameTo(rfile);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(File file, String registryKey, String delimeter) {
        String retValue = "";
        if (!file.exists()) {
            return retValue;
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String readLine;
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            while ((readLine = br.readLine()) != null) {
                int startChar;
                if (!readLine.startsWith(registryKey) || (startChar = readLine.indexOf(delimeter)) == -1) continue;
                retValue = readLine.substring(startChar + 1);
            }
            String startChar = retValue;
            return startChar;
        }
        catch (IOException ioe) {
            Log.catching(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Log.catching(e);
                }
            }
        }
        return retValue;
    }

    public static String getContent(File file, String registryKey) {
        return ContentEditUtil.getContent(file, registryKey, "=");
    }
}

