#!/bin/bash -ex

SHORTCUT_DIR_PATH=${HOME}/.local/share
APPLICATION_DIR_PATH=${SHORTCUT_DIR_PATH}/applications
DESKTOP_FILE_PATH=${APPLICATION_DIR_PATH}/tizen-studio-packagemanager.desktop					  
DESKTOP_EXECUTE_FILE_PATH=${INSTALLED_PATH}/package-manager/package-manager.bin
DESKTOP_ICON_FILE_PATH=${INSTALLED_PATH}/package-manager/tizen-studio-package-manager.png
DESKTOP_NAME="Package Manager"
DESKTOP_COMMENT="Package Manager for Tizen Studio"

##if not exist 'applications' directory
if [ ! -e ${APPLICATION_DIR_PATH} ]; then
	mkdir -p ${APPLICATION_DIR_PATH}
fi

##create 'Package Manager' shortcut
${MAKESHORTCUT_PATH} \
-f "${DESKTOP_FILE_PATH}" \
-e "${DESKTOP_EXECUTE_FILE_PATH}" \
-i "${DESKTOP_ICON_FILE_PATH}" \
-n "${DESKTOP_NAME}" \
-c "${DESKTOP_COMMENT}"

