/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.profiling.launch.Messages;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonBuildMessages;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchConfiguration;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.ArrayUtil;

public abstract class ProfileLaunchShortcut
implements ILaunchShortcut {
    protected PkgCommandTarget target = null;
    protected IDevice device = null;
    private IPackageUtil pkgUtil = null;
    private boolean result;
    private final String PROJECT_SOURCE_CONTAINER = "Project Source mapping";
    private final String PLATFORM_SOURCE_CONTAINER = "Platform Source mapping";
    protected ISourceLookupDirector fLocator;

    public void launch(IEditorPart iEditorPart, String string) {
        this.searchAndLaunch(new Object[]{iEditorPart.getEditorInput()}, string);
    }

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object object = iStructuredSelection.getFirstElement();
            IProject iProject = null;
            if (object instanceof IBinary) {
                IBinary iBinary = (IBinary)object;
                iProject = iBinary.getCProject().getProject();
            } else if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                iProject = iResource.getProject();
            }
            if (iProject != null) {
                if (PlatformProjectUtil.isTizenPlatformProject((IProject)iProject)) {
                    this.searchAndLaunchPlatform(((IStructuredSelection)iSelection).toArray(), string);
                } else {
                    this.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string);
                }
            }
        }
    }

    public void launch(IBinary iBinary, String string) {
        ILaunchConfiguration iLaunchConfiguration = this.findLaunchConfiguration(iBinary, string);
        if (iLaunchConfiguration != null) {
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        }
    }

    public static void showErrorDialog(final String string, String string2, Exception exception) {
        String string3 = Messages.getString("ProfileLaunchShortcut.targetcheck");
        Status status = new Status(4, string3, 0, string2, (Throwable)exception);
        Display.getDefault().syncExec(new Runnable((IStatus)status){
            private final /* synthetic */ IStatus val$status;
            {
                this.val$status = iStatus;
            }

            @Override
            public void run() {
                ErrorDialog.openError(null, (String)"Profile Error", (String)string, (IStatus)this.val$status);
            }
        });
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary iBinary, String string) {
        Object[] objectArray;
        ILaunchConfigurationType iLaunchConfigurationType;
        IWorkbenchWindow iWorkbenchWindow;
        if (iBinary == null) {
            iWorkbenchWindow = ViewUtil.getWorkbenchWindow();
            if (iWorkbenchWindow != null && iWorkbenchWindow.getSelectionService() != null && (iLaunchConfigurationType = iWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection && (objectArray = ((IStructuredSelection)iLaunchConfigurationType).toArray()).length == 1) {
                IProject iProject = (IProject)objectArray[0];
                return this.createConfiguration(iProject, string);
            }
            ProfileLaunchShortcut.showErrorDialog("Cannot find a project name.", "Cannot find a project name.", null);
        }
        iWorkbenchWindow = null;
        iLaunchConfigurationType = this.getLaunchConfigType();
        objectArray = LaunchUtils.getCurrentDeployDevice();
        List<ILaunchConfiguration> list = Collections.emptyList();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            list = new ArrayList(iLaunchConfigurationArray.length);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                IResource iResource;
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n];
                String string2 = iLaunchConfiguration.getAttribute("org.tizen.common.launch.device.id", "");
                String string3 = LaunchUtils.getDeviceId((IDevice)objectArray);
                IPath iPath = AbstractCLaunchDelegate.getProgramPath((ILaunchConfiguration)iLaunchConfiguration);
                String string4 = AbstractCLaunchDelegate.getProjectName((ILaunchConfiguration)iLaunchConfiguration);
                if (iBinary != null && (iResource = iBinary.getResource()) != null) {
                    IPath iPath2 = iResource.getProjectRelativePath();
                    if (iPath != null && iPath.equals((Object)iPath2) && string4 != null && string4.equals(iBinary.getCProject().getProject().getName()) && string2.equals(string3)) {
                        list.add(iLaunchConfiguration);
                    }
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        int n = list.size();
        if (n < 1) {
            if (iBinary != null) {
                iWorkbenchWindow = this.createConfiguration(iBinary);
            }
        } else {
            iWorkbenchWindow = n == 1 ? (ILaunchConfiguration)list.get(0) : this.chooseConfiguration(list, string);
        }
        return iWorkbenchWindow;
    }

    protected ILaunchConfiguration findLaunchConfiguration(IProject iProject, String string) {
        IDevice iDevice = LaunchUtils.getCurrentDeployDevice();
        if (iDevice == null) {
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.NO_TARGET);
            return null;
        }
        ILaunchConfiguration iLaunchConfiguration = null;
        iLaunchConfiguration = this.createConfiguration(iProject, string);
        return iLaunchConfiguration;
    }

    protected abstract ILaunchConfigurationType getLaunchConfigType();

    protected abstract void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    protected ILaunchConfiguration createConfiguration(IBinary iBinary) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            IPath iPath;
            IResource iResource = iBinary.getResource();
            if (iResource != null && (iPath = iResource.getProjectRelativePath()) != null) {
                String string = iPath.toString();
                ILaunchConfigurationType iLaunchConfigurationType = this.getLaunchConfigType();
                if (iLaunchConfigurationType != null) {
                    IDevice iDevice = LaunchUtils.getCurrentDeployDevice();
                    ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iBinary.getElementName()));
                    iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", string);
                    iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", iBinary.getCProject().getElementName());
                    iLaunchConfigurationWorkingCopy.setMappedResources(new IResource[]{iBinary.getResource(), iBinary.getResource().getProject()});
                    iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                    this.setDefaultProfileAttributes(iLaunchConfigurationWorkingCopy);
                    ICProjectDescription iCProjectDescription = CCorePlugin.getDefault().getProjectDescription(iBinary.getCProject().getProject());
                    if (iCProjectDescription != null) {
                        String string2 = iCProjectDescription.getActiveConfiguration().getId();
                        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", string2);
                        String string3 = iCProjectDescription.getActiveConfiguration().getName();
                        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", string3);
                        LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)iLaunchConfigurationWorkingCopy, (IDevice)iDevice);
                    }
                    iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
                }
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ILaunchConfiguration createConfiguration(IProject iProject, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            String string2;
            ILaunchConfigurationType iLaunchConfigurationType = this.getLaunchConfigType();
            if (iLaunchConfigurationType == null) return iLaunchConfiguration;
            if (PlatformProjectUtil.isTizenPlatformProject((IProject)iProject)) {
                IDevice iDevice = LaunchUtils.getCurrentDeployDevice();
                ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(iProject.getName()));
                this.setPkgCommandTarget(iProject);
                if (!this.checkPackaging(iProject)) {
                    return null;
                }
                if (!this.checkInitializedRootstrap()) {
                    MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)PlatformLaunchMessages.ROOTSTRAP_NOT_INITED);
                    return null;
                }
                TizenLaunchConfiguration tizenLaunchConfiguration = new TizenLaunchConfiguration(iLaunchConfigurationWorkingCopy, iDevice);
                tizenLaunchConfiguration.setDefaults();
                this.setAttributes(iLaunchConfigurationWorkingCopy, iProject);
                this.setSourceContainer(iProject, iLaunchConfigurationWorkingCopy);
                ICProjectDescription iCProjectDescription = CCorePlugin.getDefault().getProjectDescription(iProject);
                if (iCProjectDescription == null) return iLaunchConfigurationWorkingCopy.doSave();
                String string3 = iCProjectDescription.getActiveConfiguration().getId();
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", string3);
                String string4 = iCProjectDescription.getActiveConfiguration().getName();
                iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", string4);
                LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)iLaunchConfigurationWorkingCopy, (IDevice)iDevice);
                return iLaunchConfigurationWorkingCopy.doSave();
            }
            String string5 = iProject.getName();
            IDevice iDevice = LaunchUtils.getCurrentDeployDevice();
            IProject iProject2 = iProject;
            String string6 = ProjectUtil.getLaunchConfigurationName((IProject)iProject2);
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(string6));
            if (ProjectUtil.getDefaultConfiguration((IProject)iProject) != null) {
                string2 = String.valueOf(ProjectUtil.getDefaultConfiguration((IProject)iProject).getName()) + File.separatorChar + ProjectUtil.getBinaryName((IProject)iProject);
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", string2);
            }
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", string5);
            iLaunchConfigurationWorkingCopy.setMappedResources(new IResource[]{iProject});
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            this.setDefaultProfileAttributes(iLaunchConfigurationWorkingCopy);
            string2 = CCorePlugin.getDefault().getProjectDescription(iProject);
            if (string2 == null) return iLaunchConfigurationWorkingCopy.doSave();
            String string7 = string2.getActiveConfiguration().getId();
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", string7);
            String string8 = string2.getActiveConfiguration().getName();
            iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", string8);
            LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)iLaunchConfigurationWorkingCopy, (IDevice)iDevice);
            return iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.tizen.nativeplatform.launch.PlatformLaunchConfigurationType");
    }

    protected void setPkgCommandTarget(IProject iProject) {
        IConfiguration iConfiguration = PlatformConfigurationManager.getDefaultConfiguration((IProject)iProject);
        if (iConfiguration == null) {
            this.handleFail(Messages.getString("ProfileLaunchShortcut.configuration_is_null"));
            return;
        }
        String string = PlatformConfigurationManager.getBuildTargetName((IConfiguration)iConfiguration);
        if (string == null) {
            this.handleFail(Messages.getString("ProfileLaunchShortcut.failed_to_get_build_target_name"));
            return;
        }
        String string2 = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(string);
        PlatformRootstrap platformRootstrap = RootstrapProxy.getProxy().getRootstrap(string2);
        this.target = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), this.device, platformRootstrap);
    }

    protected boolean checkPackaging(final IProject iProject) {
        final IConfiguration iConfiguration = PlatformConfigurationManager.getDefaultConfiguration((IProject)iProject);
        if (iConfiguration == null) {
            this.handleFail(Messages.getString("ProfileLaunchShortcut.configuration_is_null"));
            return false;
        }
        List list = this.pkgUtil.getPackages(iProject, iConfiguration);
        if (list == null) {
            this.handleFail(Messages.getString("ProfileLaunchShortcut.list_of_packages_is_null"));
            return false;
        }
        if (list.isEmpty()) {
            if (PlatformLaunchUtil.questionPackaging((IProject)iProject)) {
                if (!this.buildProject(iProject, iConfiguration)) {
                    DialogUtil.openErrorDialog((String)CommonBuildMessages.FAIL_TO_BUILD_PACKAGE);
                    return PlatformLaunchUtil.questionContinue();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommonPackageUtil.cachePkgChecksum((IProject)iProject, (IConfiguration)iConfiguration);
                    }
                });
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean checkInitializedRootstrap() {
        return this.target != null && this.target.getRootstrap().checkInitialized();
    }

    protected void setAttributes(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, IProject iProject) {
        this.setProjectAttr(iLaunchConfigurationWorkingCopy, iProject);
        this.setWorkingDirAttr(iLaunchConfigurationWorkingCopy);
        this.setDebuggerAttr(iLaunchConfigurationWorkingCopy);
        this.setBuildAttr(iLaunchConfigurationWorkingCopy, iProject);
    }

    protected void setProjectAttr(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, IProject iProject) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", iProject.getName());
        iLaunchConfigurationWorkingCopy.setMappedResources(new IResource[]{iProject});
    }

    protected void setWorkingDirAttr(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    protected void setDebuggerAttr(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "org.tizen.nativecommon.launch.TizenDebugger");
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, "org.tizen.nativeplatform.launch.PlatformCommandFactory");
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
    }

    protected void setBuildAttr(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, IProject iProject) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 0);
        ICProjectDescription iCProjectDescription = CCorePlugin.getDefault().getProjectDescription(iProject);
        if (iCProjectDescription != null) {
            String string = iCProjectDescription.getActiveConfiguration().getId();
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", string);
        }
    }

    protected void setSourceContainer(IProject iProject, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        PlatformRootstrap platformRootstrap = this.target.getRootstrap();
        if (platformRootstrap == null || platformRootstrap.getPath() == null) {
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)PlatformLaunchMessages.CANNOT_FIND_ROOTSTRAP);
            return;
        }
        String string = platformRootstrap.getPath().toString();
        String string2 = "";
        if (OSChecker.isWindows()) {
            string2 = string;
        } else {
            string2 = SmartBuildInterface.getInstance().getPlatformRootstrapPath(string);
            if (string2 == null) {
                return;
            }
        }
        MappingSourceContainer mappingSourceContainer = new MappingSourceContainer("Project Source mapping");
        MapEntrySourceContainer mapEntrySourceContainer = new MapEntrySourceContainer();
        String[] stringArray = PlatformLaunchUtil.getProjectInfo((IProject)iProject);
        if (stringArray == null) {
            return;
        }
        String string3 = String.format("/usr/src/debug/%s-%s", stringArray[0], stringArray[1]);
        String string4 = iProject.getLocation().toOSString();
        mapEntrySourceContainer.setBackendPath((IPath)new Path(string3));
        mapEntrySourceContainer.setLocalPath((IPath)new Path(string4));
        mappingSourceContainer.addMapEntry(mapEntrySourceContainer);
        MappingSourceContainer mappingSourceContainer2 = new MappingSourceContainer("Platform Source mapping");
        MapEntrySourceContainer mapEntrySourceContainer2 = new MapEntrySourceContainer();
        string3 = "/usr";
        string4 = new Path(string2).append("usr").toString();
        mapEntrySourceContainer2.setBackendPath((IPath)new Path(string3));
        mapEntrySourceContainer2.setLocalPath((IPath)new Path(string4));
        mappingSourceContainer2.addMapEntry(mapEntrySourceContainer2);
        if (this.fLocator != null) {
            this.fLocator.dispose();
            this.fLocator = null;
        }
        try {
            String string5 = iLaunchConfigurationWorkingCopy.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            String string6 = iLaunchConfigurationWorkingCopy.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (string6 == null) {
                string6 = iLaunchConfigurationWorkingCopy.getType().getSourceLocatorId();
            }
            if (string6 == null) {
                return;
            }
            IPersistableSourceLocator iPersistableSourceLocator = this.getLaunchManager().newSourceLocator(string6);
            if (!(iPersistableSourceLocator instanceof AbstractSourceLookupDirector)) {
                string5 = null;
                string6 = iLaunchConfigurationWorkingCopy.getType().getSourceLocatorId();
                if (string6 == null) {
                    return;
                }
                iPersistableSourceLocator = this.getLaunchManager().newSourceLocator(string6);
                if (!(iPersistableSourceLocator instanceof AbstractSourceLookupDirector)) {
                    return;
                }
            }
            this.fLocator = (AbstractSourceLookupDirector)iPersistableSourceLocator;
            if (string5 == null) {
                this.fLocator.initializeDefaults((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            } else {
                this.fLocator.initializeFromMemento(string5, (ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            }
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            ISourceContainer[] iSourceContainerArray = this.fLocator.getSourceContainers();
            int n = iSourceContainerArray.length;
            ISourceContainer[] iSourceContainerArray2 = new ISourceContainer[n + 2];
            int n2 = 0;
            ISourceContainer[] iSourceContainerArray3 = iSourceContainerArray;
            int n3 = iSourceContainerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ISourceContainer iSourceContainer = iSourceContainerArray3[n4];
                iSourceContainerArray2[n2++] = iSourceContainer;
                ++n4;
            }
            iSourceContainerArray2[n2++] = mappingSourceContainer;
            iSourceContainerArray2[n2] = mappingSourceContainer2;
            this.fLocator.setSourceContainers(iSourceContainerArray2);
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, this.fLocator.getMemento());
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, this.fLocator.getId());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected boolean buildProject(final IProject iProject, final IConfiguration iConfiguration) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = iWorkbenchWindow.getShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ProfileLaunchShortcut.this.result = CommonPackageUtil.build((IProject)iProject, (IConfiguration)iConfiguration, (IProgressMonitor)iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return this.result;
    }

    protected Shell getAvaiableShell() {
        Shell shell = CDebugUIPlugin.getActiveWorkbenchWindow().getShell();
        if (shell == null) {
            shell = PlatformLaunchUtil.getAvaiableShell();
        }
        return shell;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private void searchAndLaunchPlatform(Object[] objectArray, String string) {
        if (ArrayUtil.isEmpty((Object[])objectArray)) {
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.PROJECT_NOT_SELECTED);
            return;
        }
        this.device = ConnectionPlugin.getDefault().getCurrentDevice();
        if (this.device == null) {
            DialogUtil.openErrorDialog((String)TizenLaunchMessages.CANNOT_CONNECT_TO_DEVICE);
            return;
        }
        if (!PlatformLaunchUtil.checkAndSetDeviceRootOn((IDevice)this.device)) {
            DialogUtil.openErrorDialog((String)PlatformLaunchMessages.DEVICE_IS_NOT_ROOT_ON);
            return;
        }
        this.pkgUtil = PlatformInstances.getPackageUtil();
        if (objectArray != null && objectArray.length > 0) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration;
                IProject iProject;
                IResource iResource;
                if (objectArray[n2] instanceof IAdaptable && (iResource = (IResource)((IAdaptable)objectArray[n2]).getAdapter(IResource.class)) != null && (iProject = iResource.getProject()) != null && (iLaunchConfiguration = this.findLaunchConfiguration(iProject, string)) != null) {
                    DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
                }
                ++n2;
            }
        }
    }

    private void searchAndLaunch(final Object[] objectArray, String string) {
        if (objectArray != null && objectArray.length > 0) {
            IBinary iBinary = null;
            if (objectArray.length == 1 && objectArray[0] instanceof IBinary) {
                iBinary = (IBinary)objectArray[0];
            } else {
                final ArrayList<IBinary> arrayList = new ArrayList<IBinary>();
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getActiveWorkbenchShell());
                IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                        int n = objectArray.length;
                        iProgressMonitor.beginTask(Messages.getString("ProfileLaunchShortcut.Looking_for_executables"), n);
                        try {
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            int n2 = 0;
                            while (n2 < n) {
                                ICProject iCProject;
                                IResource iResource;
                                if (objectArray[n2] instanceof IAdaptable && (iResource = (IResource)((IAdaptable)objectArray[n2]).getAdapter(IResource.class)) != null && (iCProject = CoreModel.getDefault().create(iResource.getProject())) != null) {
                                    try {
                                        IBinary[] iBinaryArray = iCProject.getBinaryContainer().getBinaries();
                                        if (iBinaryArray != null && ManagedBuildManager.getBuildInfo((IResource)iResource.getProject()) != null) {
                                            IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)iResource.getProject()).getDefaultConfiguration();
                                            String string = iConfiguration.toString();
                                            int n3 = 0;
                                            while (n3 < iBinaryArray.length) {
                                                String string2;
                                                if ((iBinaryArray[n3].isExecutable() || iBinaryArray[n3].isSharedLib()) && (string2 = iBinaryArray[n3].getPath().removeLastSegments(1).lastSegment()) != null && string2.equals(string)) {
                                                    arrayList.add(iBinaryArray[n3]);
                                                }
                                                ++n3;
                                            }
                                        }
                                    }
                                    catch (CModelException cModelException) {
                                        cModelException.printStackTrace();
                                    }
                                }
                                if (iProgressMonitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                subProgressMonitor.done();
                                ++n2;
                            }
                        }
                        finally {
                            iProgressMonitor.done();
                        }
                    }
                };
                try {
                    progressMonitorDialog.run(true, true, iRunnableWithProgress);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.handleFail(invocationTargetException.getMessage());
                    return;
                }
                int n = arrayList.size();
                if (n == 1) {
                    iBinary = (IBinary)arrayList.get(0);
                } else if (n > 1) {
                    iBinary = this.chooseBinary(arrayList, string);
                }
            }
            this.launch(iBinary, string);
        } else {
            this.handleFail(Messages.getString("ProfileLaunchShortcut.no_project_selected"));
        }
    }

    protected void handleFail(String string) {
        MessageDialog.openError((Shell)this.getActiveWorkbenchShell(), (String)Messages.getString("ProfileLaunchShortcut.Valgrind_Launcher"), (String)string);
    }

    protected IBinary chooseBinary(List<IBinary> list, String string) {
        CElementLabelProvider cElementLabelProvider = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(iBinary.getPath().lastSegment());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        CElementLabelProvider cElementLabelProvider2 = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(String.valueOf(iBinary.getCPU()) + (iBinary.isLittleEndian() ? "le" : "be"));
                    stringBuffer.append(" - ");
                    stringBuffer.append(iBinary.getPath().toString());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(this.getActiveWorkbenchShell(), (ILabelProvider)cElementLabelProvider, (ILabelProvider)cElementLabelProvider2);
        twoPaneElementSelector.setElements(list.toArray());
        twoPaneElementSelector.setTitle(Messages.getString("ProfileLaunchShortcut.Profile_With_Valgrind"));
        twoPaneElementSelector.setMessage(Messages.getString("ProfileLaunchShortcut.Choose_a_local_application"));
        twoPaneElementSelector.setUpperListLabel(Messages.getString("ProfileLaunchShortcut.Binaries"));
        twoPaneElementSelector.setLowerListLabel(Messages.getString("ProfileLaunchShortcut.Qualifier"));
        twoPaneElementSelector.setMultipleSelection(false);
        if (twoPaneElementSelector.open() == 0) {
            return (IBinary)twoPaneElementSelector.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(Messages.getString("ProfileLaunchShortcut.Launch_Configuration_Selection"));
        elementListSelectionDialog.setMessage(Messages.getString("ProfileLaunchShortcut.Choose_a_launch_configuration"));
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected Shell getActiveWorkbenchShell() {
        return ProfileLaunchPlugin.getActiveWorkbenchShell();
    }
}

