/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.launch;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.linuxtools.valgrind.launch.Messages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ValgrindLaunchPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.launch";
    public static final String LAUNCH_ID = "org.eclipse.linuxtools.valgrind.launch.valgrindLaunch";
    public static final String RESULT_DIR = "/tmp/";
    public static final String XML_FILE = "valgrind_result.xml";
    public static final String TOOL_EXT_ID = "valgrindTools";
    public static final String TOOL_EXT_DEFAULT = "org.eclipse.linuxtools.valgrind.launch.memcheck";
    protected static final String EXT_ELEMENT = "tool";
    protected static final String EXT_ATTR_NAME = "name";
    protected static final String EXT_ATTR_ID = "id";
    protected static final String EXT_ATTR_PAGE = "page";
    protected static final String EXT_ATTR_DELEGATE = "delegate";
    protected HashMap<String, IConfigurationElement> toolMap;
    private static ValgrindLaunchPlugin plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static ValgrindLaunchPlugin getDefault() {
        return plugin;
    }

    public String[] getRegisteredToolIDs() {
        Set<String> set = this.getToolMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public String getToolName(String string) {
        String string2 = null;
        IConfigurationElement iConfigurationElement = this.getToolMap().get(string);
        if (iConfigurationElement != null) {
            string2 = iConfigurationElement.getAttribute(EXT_ATTR_NAME);
        }
        return string2;
    }

    public IValgrindToolPage getToolPage(String string) throws CoreException {
        Object object;
        IValgrindToolPage iValgrindToolPage = null;
        IConfigurationElement iConfigurationElement = this.getToolMap().get(string);
        if (iConfigurationElement != null && (object = iConfigurationElement.createExecutableExtension(EXT_ATTR_PAGE)) instanceof IValgrindToolPage) {
            iValgrindToolPage = (IValgrindToolPage)object;
        }
        if (iValgrindToolPage == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.getString("ValgrindLaunchPlugin.Cannot_retrieve_page")));
        }
        return iValgrindToolPage;
    }

    public IValgrindLaunchDelegate getToolDelegate(String string) throws CoreException {
        Object object;
        IValgrindLaunchDelegate iValgrindLaunchDelegate = null;
        IConfigurationElement iConfigurationElement = this.getToolMap().get(string);
        if (iConfigurationElement != null && (object = iConfigurationElement.createExecutableExtension(EXT_ATTR_DELEGATE)) instanceof IValgrindLaunchDelegate) {
            iValgrindLaunchDelegate = (IValgrindLaunchDelegate)object;
        }
        if (iValgrindLaunchDelegate == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.getString("ValgrindLaunchPlugin.Cannot_retrieve_delegate")));
        }
        return iValgrindLaunchDelegate;
    }

    public File parseWSPath(String string) throws CoreException {
        string = LaunchUtils.getStringVariableManager().performStringSubstitution(string);
        Path path = new Path(string);
        File file = null;
        if (path.isAbsolute()) {
            file = new File(path.toOSString());
        } else {
            IPath iPath;
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (iResource != null && (iPath = iResource.getLocation()) != null) {
                file = iPath.toFile();
            }
        }
        return file;
    }

    protected void initializeToolMap() {
        this.toolMap = new HashMap();
        if (Platform.getExtensionRegistry() == null) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, TOOL_EXT_ID);
        if (iExtensionPoint == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        if (iConfigurationElementArray != null) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                if (iConfigurationElement.getName() != null && iConfigurationElement.getName().equals(EXT_ELEMENT) && (string = iConfigurationElement.getAttribute(EXT_ATTR_ID)) != null && iConfigurationElement.getAttribute(EXT_ATTR_NAME) != null && iConfigurationElement.getAttribute(EXT_ATTR_PAGE) != null && iConfigurationElement.getAttribute(EXT_ATTR_DELEGATE) != null) {
                    this.toolMap.put(string, iConfigurationElement);
                }
                ++n2;
            }
        }
    }

    protected HashMap<String, IConfigurationElement> getToolMap() {
        if (this.toolMap == null) {
            this.initializeToolMap();
        }
        return this.toolMap;
    }

    public String escapeAndQuote(String string) {
        String string2 = string.replaceAll(" ", "\\ ");
        return string2;
    }
}

