/**
 * error-handler.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var DError = require('./exception');
var domain = require('domain');
var errorHandler = function () {
    this.run = function (hash) {
        var thisDomain = domain.create();
        if (hash['try'] && hash['catch']) {
            thisDomain.on('error', function (err) {
                var error;
                try {
                    error = new DError('ERR004', {stack: err.stack}, err);
                    console.log(error);
                } catch(er) {
                    error = err;
                    console.log(er);
                }
                hash['catch'](error);
            });
            thisDomain.run(function () {
                hash['try']();
            });
        } else {
            thisDomain.on('error', function (err) {
                console.log(err.message);
                process.exit();
            });
            thisDomain.run(function () {
                throw new DError('ERR003');
            });
        }
    };
};

module.exports = new errorHandler();
