/**
 * extension-point.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

/**
 * @module core/plugin/extension-point
 */
/**
 * @constructor
 * @param {string} json
 * @param {module:core/plugin/plugin.Plugin} parent
 * @memberOf module:core/plugin/extension-point
 */
function ExtensionPoint(json, parent) {
    /** @tyep {module:core/plugin/plugin.Plugin} */
    var plugin = parent;

    /** @tyep {string} */
    this.id = json.id;
    /** @tyep {string} */
    this.description = json.description;
    /** @tyep {string} */
    this.schema = json.schema;
    /** @tyep {Array.<module:core/plugin/extension.Extension>} */
    this.extensions = [];
    /** @tyep {string} */
    this.pluginName = parent.name;

    /**
     * @method getSchemaType
     * @param {string} name
     * @returns {schema}
     * @memberOf module:core/plugin/extension-point.ExtensionPoint
     */
    this.getSchemaType = function (name) {
        for (var i = 0; i < this.schema.length; i++) {
            var schema = this.schema[i];

            if (schema['name'] === name) {
                return schema['type'];
            }
        }
        return null;
    };


    /**
     * @method addExtension
     * @param {module:core/plugin/extension.Extension} ex - extension
     * @returns {boolean}
     * @memberOf module:core/plugin/extension-point.ExtensionPoint
     */
    this.addExtension = function (ex) {
        // verify
        if (this.id !== ex.extensionPointId)
            return false;
        for (var i = 0; i < this.schema.length; i++) {
            var schema = this.schema[i];
            if (!ex.hasAttribute(schema['name']))
                return false;
        }

        // push
        this.extensions.push(ex);

        return true;
    };


    /**
     * @method getExtension
     * @returns {module:core/plugin/extension.Extension}
     * @memberOf module:core/plugin/extension-point.ExtensionPoint
     */
    this.getExtensions = function () {
        return this.extensions;
    };


    /**
     * @method getPluginPath
     * @returns {string}
     * @memberOf module:core/plugin/extension-point.ExtensionPoint
     */
    this.getPluginPath = function () {
        return plugin.pluginPath;
    };

    /**
     * @method getPlugin
     * @returns {module:core/plugin/plugin.Plugin}
     * @memberOf module:core/plugin/extension-point.ExtensionPoint
     */
    this.getPlugin = function () {
        return plugin;
    };
}


/**
 * @function create
 * @param {module:core/plugin/plugin.Plugin} parent - parent
 * @returns {module:core/plugin/extension-point.ExtensionPoint}
 * @memberOf module:core/plugin/extension-point
 */

module.exports.create = function (json, parent) {
    return new ExtensionPoint(json, parent);
};
