/**
 * extension.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/


/**
 * @module core/plugin/extension
 */

/**
 * @constructor
 * @param {string} json
 * @param {module:core/plugin/plugin.Plugin} parent - parent
 * @memberOf module:core/plugin/extension
 */
function Extension(json, parent) {
    var self = this;
    /** @type {module:core/plugin/plugin.Plugin} */
    var plugin = parent;

    /** @type {string} */
    this.extensionPointId = json.extensionPointId;
    /** @type {object} */
    this.attributes = json.attributes;
    /** @type {string} */
    this.pluginName = parent.name;

    /**
     * @method getAttribute
     * @param {string} key
     * @return {string}
     * @memberOf module:core/plugin/extension.Extension
     */
    this.getAttribute = function (key) {
        return self.attributes[key];
    };


    /**
     * @method hasAttribute
     * @param {string} key
     * @return {boolean}
     * @memberOf module:core/plugin/extension.Extension
     */
    this.hasAttribute = function (key) {
        return (self.attributes[key] !== undefined);
    };

    /**
     * @method getPluginPath
     * @return {string}
     * @memberOf module:core/plugin/extension.Extension
     */
    this.getPluginPath = function () {
        return plugin.pluginPath;
    };

    /**
     * @method getPlugin
     * @return {module:core/plugin/plugin.Plugin}
     * @memberOf module:core/plugin/extension.Extension
     */
    this.getPlugin = function () {
        return plugin;
    };
}


/**
 * @function create
 * @param {string} json - json
 * @param {module:core/plugin/plugin.Plugin} parent - parent
 * @returns {module:core/plugin/extension.Extension}
 * @memberOf module:core/plugin/extension
 */

module.exports.create = function (json, parent) {
    return new Extension(json, parent);
};

