/**
 * package.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var async = require('async');

var Zip = require('../dibs.core/zip.js');

var PACKAGE_INFO_FILE = 'package.json';
var PLUGIN_INFO_FILE = 'plugin.json';


module.exports.readPackageInfoFromFile = readPackageInfoFromFile;
module.exports.getInfoFromPackageFileName = getInfoFromPackageFileName;


function readPackageInfoFromFile(pkgFilePath, callback) {
    async.waterfall([
        function (cb) {
            Zip.unzipAFileString(pkgFilePath, PLUGIN_INFO_FILE, function (err, data) {
                // NOTE. On windows, even if the file does not exist, err is null
                //       So, data length must be checked
                if (!err && data.length > 0) {
                    cb(err, data, true);
                } else {
                    Zip.unzipAFileString(pkgFilePath, PACKAGE_INFO_FILE, function (err, data) {
                        cb(err, data, false);
                    });
                }
            });
        },
        function (data, isPlugin, cb) {
            cb(null, JSON.parse(data), isPlugin);
        }
    ], function (err, pkg, isPlugin) {
        callback(err, pkg, isPlugin);
    });
}


function getInfoFromPackageFileName(fileName) {
    var regExp = /(.*)_(.*)\.zip/;

    var result = regExp.exec(fileName);
    if (!result) {
        return null;
    }
    if (result[1] === '' || result[2] === '') {
        return null;
    }

    return {
        name: result[1],
        version: result[2]
    };
}
