/**
 * query-parser.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var _ = require('underscore');

module.exports.select = function (condition) {
    var query = [];
    _.each(condition, function (value, key, list) {
        if (key === '$or') {
            if (!_.isArray(value)) {
                return -1;
            }
            var q = [];
            _.each(value, function (v) {
                q.push(parseCondition(v));
            });
            query.push(q.join(' OR '));
        } else {
            if (_.isString(value) || _.isNumber(value) || _.isBoolean(value)) {
                query.push(key + " = " + valueToSql(value));
            } else {
                _.each(value, function (v, k, l) {
                    if (k === '$ne') {
                        query.push(key + " != " + valueToSql(v));
                    } else if (k === '$gt') {
                        query.push(key + " > " + valueToSql(v));
                    } else if (k === '$gte') {
                        query.push(key + " >= " + valueToSql(v));
                    } else if (k === '$lt') {
                        query.push(key + " < " + valueToSql(v));
                    } else if (k === '$lte') {
                        query.push(key + " =< " + valueToSql(v));
                    } else {
                        return -1;
                    }
                });
            }
        }
    });

    return query.join(' AND ');
};

function valueToSql(value) {
    if (_.isString(value)) {
        return "'" + value + "'";
    } else {
        return value;
    }
}
