/**
 * project.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var fs = require('fs');
var path = require('path');

var dibs = require('../../core/dibs');
var Job = require('../../plugins/dibs.model.common/job.js');

/**
 * @module models/simple/project
 */

function SimpleJob(baseJob) {
    var self = this;
    Job.copy(this, baseJob);
    self.timeout = null;
    self.callback = null;
}


function createJob(user_email, distribution_name, prjName, prjType, environment_name, parentId, distType, options, callback) {
    Job.create(user_email, distribution_name, distType, prjName, prjType, environment_name, parentId, null, options,
        function (err, newJob) {
            callback(err, new SimpleJob(newJob));
        });
}
module.exports.createJob = createJob;


/**
 * Initialize simple job
 * @function initializeJob
 * @param {module:models/job~Job} job - job
 * @param {string} workDir - workDir
 * @param {module:lib/utils.callback_error} callback - callback(error)
 * @memberOf module:models/tizen-project/project
 */
function initializeJob(job, options, callback) {
    return callback(null, job);
}
module.exports.initializeJob = initializeJob;

/**
 * @function executeJob
 * @param {string} job - job
 * @param {string} workDir - workDir
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:models/simple/project
 */

module.exports.executeJob = function (job, options, callback) {
    var jobWorkPath = options.jobWorkPath;

    job.callback = callback;
    job.timeout = setTimeout(function () {
        var repoServers = dibs.getServersByType('repo');
        if (repoServers.length > 0) {
            // create dummy file
            var resultFile = path.join(jobWorkPath, job.id + '.pkg');
            fs.writeFileSync(resultFile, 'Dummy File' + job.id);
            repoServers[0].registerPackages([resultFile], {
                distName: job.distName
            }, function (err) {
                callback(err, job);
            });
        } else {
            return callback(null, job);
        }
    }, 3000);

    return job;
};

module.exports.cancelJob = function (job, callback) {
    clearTimeout(job.timeout);
    callback(null);
    job.callback(new Error('Job is canceled!'));
};
