/**
 * remote.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../core/dibs');
var path = require('path');
var extfs = require('fs-extra');

module.exports.isDibsInstall = function (mIp, mPort, cb) {
    dibs.thisServer.innerIsDibsInstall(mIp, mPort, cb);
};

module.exports.getDibsVersion = function (mIp, mPort, cb) {
    var dibsPath = dibs.thisServer.innerGetDibsPath(mIp, mPort);
    cb(null, extfs.readJsonSync(path.join(dibsPath, 'package.json')).version);
};

module.exports.dibsInstall = function (mIp, mPort, version, binPath, cb) {
    dibs.thisServer.innerDibsInstall(mIp, mPort, version, binPath, cb);
};

module.exports.generateServerConfig = function (server, config, cb) {
    dibs.thisServer.innerGenerateServerConfig(server, config, cb);
};

module.exports.getRemoteBaseConfig = function (config, cb) {
    dibs.thisServer.innerGetBaseConfig(config, cb);
};

module.exports.npmInstall = function (mIp, mPort, cb) {
    dibs.thisServer.innerNpmInstall(mIp, mPort, cb);
};

module.exports.execServer = function (mIp, mPort, id, type, port, startOptions, cb) {
    dibs.thisServer.innerExecServer(mIp, mPort, id, type, port, startOptions, cb);
};
