/**
 * remote.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var async = require('async');

var dibs = require('../../core/dibs');
var dfs = require('../../plugins/dibs.dist-fs/dist-fs');

/**
 * @module servers/builder/remote
 */

/**
 * @function initializeJob
 * @param {string} jobId - jobId
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/builder/remote
 */

// callback = function( err, job )
module.exports.initializeJob = function (job, callback) {
    dibs.thisServer.initializeJobInternal(job, callback);
};

/**
 * @function buildJob
 * @param {string} jobId - jobId
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/builder/remote
 */

// callback = function( err, updatedJob )
module.exports.buildJob = function (job, callback) {
    dibs.thisServer.buildJobInternal(job, callback);
};

module.exports.resumeJob = function (job, handlerObj, callback) {
    dibs.thisServer.resumeJobInternal(job, handlerObj, callback);
};

/**
 * @function cancelJob
 * @param {string} jobId - jobId
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/builder/remote
 */

// callback = function( err )
module.exports.cancelJob = function (jobId, callback) {
    dibs.thisServer.cancelJobInternal(jobId, callback);
};

//DFS API
module.exports.dfsExistsFile = function (dfsPath, callback) {
    dibs.thisServer.log.info('Request dfsExistsFile: ' + dfsPath);
    dfs.existsFile(dfsPath, callback);
};

module.exports.dfsAddFile = function (dfsPath, lPath, opts, callback) {
    dibs.thisServer.log.info('Request dfsAddFile: ' + dfsPath + ', ' + lPath + ', ' + opts);
    dfs.addFile(dfsPath, lPath, opts, callback);
};

module.exports.dfsGetFile = function (lPath, dfsPath, callback) {
    dibs.thisServer.log.info('Request dfsGetFile: ' + lPath + ', ' + dfsPath);
    dfs.getFile(lPath, dfsPath, callback);
};

module.exports.dfsRemoveFile = function (lPath, dfsPath, callback) {
    dibs.thisServer.log.info('Request dfsRemoveFile: ' + lPath + ', ' + dfsPath);
    dfs.removeFile(lPath, dfsPath, callback);
};

// just for test
// callback = function( err )
module.exports.__testBuildJob = function (jobId, callback) {
    var job = null;
    async.waterfall([
        function (cb) {
            dibs.rpc.datamgr.searchJobs({
                id: jobId
            }, function (err, jobs) {
                if (!err) {
                    job = jobs[0];
                    job.status = 'INITIALIZING';
                }
                cb(err);
            });
        },
        function (cb) {
            job.initStamps = [];
            dibs.thisServer.initializeJobInternal(job, function (err) {
                cb(err);
            });
        },
        function (cb) {
            job.buildStamps = [];
            dibs.thisServer.buildJobInternal(job, cb);
        }], function (err, result) {
        callback(err, result);
    });
};

module.exports.__testGetWorkspacePath = function (callback) {
    callback(null, dibs.thisServer.getWorkspacePath());
};
