/**
 * remote.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../core/dibs');

// callback = function(err, jobId)
/**
 * @function addJob
 * @param {string} prjName - prjName
 * @param {string} args - args
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/job-manager/remote
 */
module.exports.addJob = function (userEmail, distName, prjName, environmentName, options, callback) {
    dibs.rpc.datamgr.checkJobPrivilege(userEmail, distName, prjName, options, function (err) {
        if (err) {
            callback(err, null);
        } else {
            dibs.thisServer.addJobInternal(userEmail, distName, prjName, environmentName, options, callback);
        }
    });
};

/**
 * @function addSubJob
 * @param {string} parentId - parent job id
 * @param {string} prjName - project name
 * @param {string} environmentName -target environment
 * @param {string} options - options
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/job-manager/remote
 */
module.exports.addSubJob = function (parentId, prjName, environmentName, options, callback) {
    dibs.thisServer.addSubJobInternal(parentId, prjName, environmentName, options, callback);
};


// callback = function(err)
/**
 * @function cancelJob
 * @param {string} jobId - jobId
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/job-manager/remote
 */
module.exports.cancelJob = function (jobId, callback) {
    dibs.thisServer.cancelJobInternal(jobId, callback);
};


module.exports.queryJob = function (jobId, callback) {
    dibs.thisServer.queryJobInternal(jobId, callback);
};


module.exports.waitForJobStatus = function (jobId, status, callback) {
    dibs.thisServer.waitForJobStatusInternal(jobId, status, callback);
};

module.exports.waitForBuilderStatus = function (builderId, callback) {
    dibs.thisServer.waitForBuilderStatusInternal(builderId, callback);
};

/**
 * @module servers/job-manager/remote
 */
