/**
 * remote.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../core/dibs');


/**
 * @function getServerStatus
 * @param {string} sid - sid
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/master/remote
 */
module.exports.getServerStatus = function (sid, callback) {
    dibs.thisServer.innerGetServerStatus(sid, callback);
};


/**
 * @function startServer
 * @param {string} sid - sid
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/master/remote
 */
module.exports.startServer = function (sid, callback) {
    dibs.thisServer.startServerInternal(sid, callback);
};


/**
 * @function stopServer
 * @param {string} sid - sid
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/master/remote
 */
module.exports.stopServer = function (sid, callback) {
    dibs.thisServer.stopServerInternal(sid, callback);
};


/**
 * @function restartServer
 * @param {string} sid - sid
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/master/remote
 */
module.exports.restartServer = function (sid, callback) {
    dibs.thisServer.restartServerInternal(sid, callback);
};


module.exports.downloadUpdate = function (pkgName, options, callback) {
    dibs.thisServer.downloadUpdateInternal(pkgName, options, callback);
};


module.exports.checkUpdates = function (options, callback) {
    dibs.thisServer.checkUpdatesInternal(options, callback);
};

module.exports.addServer = function (serverType, serverInfo, serverConfig, callback) {
    dibs.thisServer.addServerInternal(serverType, serverInfo, serverConfig, callback);
};

module.exports.updateServer = function (serverConfig, callback) {
    dibs.thisServer.updateServerInternal(serverConfig, callback);
};

// options: {cleanResource: (boolean)}
module.exports.removeServer = function (serverId, options, callback) {
    dibs.thisServer.removeServerInternal(serverId, options, callback);
};
module.exports.registerServerInfo = function (serverId, info, callback) {
    dibs.thisServer.registerServerInfoInternal(serverId, info, callback);
};

/**
 * @module servers/master/remote
 */

/**
 * @function __monitorServerResources
 * @param {object} server - server
 * @memberOf module:servers/master/remote
 */
module.exports.__testCheckServerResourceUsage = function (server, callback) {
    callback(null, dibs.thisServer.checkServerResourceUsage(server));
};
