/**
 * remote.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../core/dibs');
var utils = require('../../lib/utils.js');

// callback( err, snapshot )
module.exports.registerRemotePackages = function (rpaths, opts, callback) {
    dibs.log.info('(CALL)registerRemotePackages ' + JSON.stringify(process.memoryUsage()));
    dibs.thisServer.registerRemotePackagesInternal(rpaths, opts, function (err, snapshot) {
        dibs.log.info('(CALLBACK)registerRemotePackages ' + JSON.stringify(process.memoryUsage()));
        callback(err, snapshot);
    });
};


// callback( err, snapshotname )
module.exports.removePackages = function (names, opts, callback) {
    dibs.thisServer.removePackagesInternal(names, opts, callback);
};


// callback( err )
module.exports.generateSnapshot = function (sname, opts, callback) {
    dibs.thisServer.generateSnapshotInternal(sname, opts, callback);
};


// callback( err, removedFiles )
module.exports.removeSnapshot = function (sname, opts, callback) {
    dibs.thisServer.removeSnapshotInternal(sname, opts, callback);
};


// callback( err, dist )
module.exports.createDistribution = function (name, rtype, opts, callback) {
    dibs.thisServer.createDistributionInternal(name, rtype, opts, callback);
};


// callback( err )
module.exports.removeDistribution = function (name, opts, callback) {
    dibs.thisServer.removeDistributionInternal(name, opts, callback);
};


// callback( err )
module.exports.searchDistributions = function (opts, callback) {
    dibs.thisServer.searchDistributionsInternal(opts, callback);
};


// callback( err )
module.exports.updateDistributionConfig = function (name, opts, callback) {
    dibs.log.info('(CALL)updateDistributionConfig ' + JSON.stringify(process.memoryUsage()));
    dibs.thisServer.updateDistributionConfigInternal(name, opts, function (err) {
        dibs.log.info('(CALLBACK)updateDistributionConfig ' + JSON.stringify(process.memoryUsage()));
        callback(err);
    });
};


// callback( err, dist )
module.exports.synchronizeDistribution = function (name, opts, callback) {
    dibs.thisServer.synchronizeDistributionInternal(name, opts, callback);
};


// callback( err, snapshots )
module.exports.searchSnapshots = function (opts, callback) {
    var startTime = new Date();
    var connNum = utils.genRandom();
    dibs.log.info('(CALL-' + connNum + ')searchSnapshots ' + JSON.stringify(process.memoryUsage()));
    dibs.thisServer.searchSnapshotsInternal(opts, function (err, snapshots) {
        var endTime = new Date();
        var duration = (endTime - startTime);
        dibs.log.info('(CALLBACK-' + connNum + '-' + duration + ')searchSnapshots ' + JSON.stringify(process.memoryUsage()));
        callback(err, snapshots);
    });
};


// callback( err, dfsPath )
module.exports.downloadRemotePackage = function (name, opts, callback) {
    dibs.log.info('(CALL)downloadRemotePackage ' + JSON.stringify(process.memoryUsage()));
    dibs.thisServer.downloadRemotePackageInternal(name, opts, function (err, dfsPath) {
        dibs.log.info('(CALLBACK)downloadRemotePackage ' + JSON.stringify(process.memoryUsage()));
        callback(err, dfsPath);
    });
};

// callback( err )
module.exports.waitForSyncAction = function (distName, callback) {
    dibs.thisServer.waitForNextSyncAction(distName, callback);
};


// callback( err )
module.exports.getServerURL = function (callback) {
    dibs.thisServer.getServerURLInternal(callback);
};


// callback( err, release )
module.exports.createRelease = function (releaseName, distName, opts, callback) {
    dibs.thisServer.createReleaseInternal(releaseName, distName, opts, callback);
};


// callback( err, release )
module.exports.removeRelease = function (releaseName, distName, opts, callback) {
    dibs.thisServer.removeReleaseInternal(releaseName, distName, opts, callback);
};


// callback( err, release )
module.exports.updateRelease = function (release, distName, opts, callback) {
    dibs.thisServer.updateReleaseInternal(release, distName, opts, callback);
};


// callback( err, releases )
module.exports.searchReleases = function (distName, opts, callback) {
    dibs.thisServer.searchReleasesInternal(distName, opts, callback);
};


// callback( err, release )
module.exports.getRelease = function (releaseName, distName, callback) {
    dibs.thisServer.getReleaseInternal(releaseName, distName, callback);
};

/**
 * @function registerRemoteFile
 * @param {string} dfsPath - rpath
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/repository/remote
 */


/**
 * @function registerRemoteFiles
 * @param {string} rpaths - rpaths
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/repository/remote
 */


/**
 * @function removeFile
 * @param {string} fname - fname
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/repository/remote
 */


/**
 * @function generateSnapshot
 * @param {string} sname - sname
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/repository/remote
 */


/**
 * @function removeSnapshot
 * @param {string} sname - sname
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/repository/remote
 */


/**
 * @module servers/repository/remote
 */
