/**
 * remote.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../core/dibs.js');
var sizeof = require('object-sizeof');

module.exports.upper = function (string, cb) {
    console.log('request: ' + string);
    cb(null, string.replace(/[aeiou]{2,}/, 'oo').toUpperCase());
};


module.exports.add = function (src1, src2, cb) {
    console.log('request: ' + src1 + ' + ' + src2);
    cb(null, src1 + src2);
};

module.exports.size = function (obj, n, cb) {
    var objPlus = [];
    for (var i = 0; i < n; i++) {
        objPlus.push(obj);
    }
    var size = sizeof(objPlus);
    dibs.thisServer.log.info('Respond size: ' + size);

    cb(null, objPlus);
};

/**
 * @function upper
 * @param {string} string - string
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/worker/remote
 */


/**
 * @function add
 * @param {string} src1 - src1
 * @param {string} src2 - src2
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/worker/remote
 */


/**
 * @module servers/worker/remote
 */
