/**
 * dibsweb.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

define(['core/plugin-manager.js'], function (pm) {
    function DIBSWEB() {
        var self = this;

        this.isSessionAlive = function () {
            return false;
        };

        this.onStart = function () {
            async.series([
                // initialize plugins
                function (cb) {
                    pm.initialize(cb);
                },
                // load initial plugin
                function (cb) {
                    pm.loadInitialPlugin('dibs.web.core', cb);
                }
            ], function (err) {
                // TODO: Need error handling	
                if (err) console.log(err);
            });

        };
    }

    return new DIBSWEB();
});
