/**
 * sign-up-dialog.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

define([
    'dijit/Dialog',
    'dijit/form/Form',
    'dijit/form/Button',
    'dijit/form/TextBox',
    'javascripts/session-controller.js',
    'javascripts/message-dialog.js',
    'xstyle/css!stylesheets/css/controls/dialog.css'
],
    function (Dialog, Form, Button, TextBox, sessionController, MessageDialog) {

        function SignUpDialog() {

            var self = this;
            var id = 'signup-dialog';
            var signupDialog;

            var thisDialog = null;

            this.domId = function (name) {
                var prefix = 'sign-up-dialog-';
                return prefix + name;
            };

            this.createLayout = function () {
                // destroy if exist
                if (thisDialog) {
                    thisDialog.destroyRecursive();
                }

                // create new one
                thisDialog = new Dialog({
                    title: 'Sign Up',
                    baseClass: 'sign_up_dialog',
                    style: 'width:440px;height:350px',
                    content: '<div class = "ui_dialog_wrap">' +
                        '<div class = "po_cont">' +
                        '<input type="text" id=' + self.domId('email-input') + '>' +
                        '</div>' +
                        '<div class = "po_cont">' +
                        '<input type="text" id=' + self.domId('name-input') + '>' +
                        '</div>' +
                        '<div class = "po_cont">' +
                        '<input type="text" id=' + self.domId('password-input') + '>' +
                        '</div>' +
                        '<div class = "po_cont">' +
                        '<input type="text" id=' + self.domId('password-confirm-input') + '>' +
                        '</div>' +
                        '</div>' +
                        '<div class = "button_group center">' +
                        '<button id="' + self.domId('confirm-btn') + '" type="submit"></button>' +
                        '<button id="' + self.domId('cancel-btn') + '" type="submit"></button>' +
                        '</div>'
                });
            };


            this.onPreCreate = function (callback) {
                callback(null);
            };


            this.createControls = function () {
                var email = new TextBox({
                    type: 'text',
                    placeHolder: 'Mail',
                    style: 'width:100%;'
                }, self.domId('email-input'));

                var name = new TextBox({
                    type: 'text',
                    placeHolder: 'Name',
                    style: 'width:100%;'
                }, self.domId('name-input'));

                var password = new TextBox({
                    type: 'password',
                    placeHolder: 'Password',
                    style: 'width:100%;'
                }, self.domId('password-input'));

                var passwordConfirm = new TextBox({
                    type: 'password',
                    placeHolder: 'Password Confirmation',
                    style: 'width:100%;'
                }, self.domId('password-confirm-input'));

                new Button({
                    label: 'Confirm',
                    className: 'primary',
                    onClick: function () {
                        sessionController.signup(email.value, name.value, password.value, passwordConfirm.value, function (err) {
                            if (err) {
                                var dialog = new MessageDialog(err, {
                                    title: 'Error'
                                });
                                dialog.show();
                            } else {
                                thisDialog.hide();

                                var dialog = new MessageDialog(
                                    'Welcome to DIBS ' + name.value + '!', {});
                                dialog.show();
                            }
                        });
                    }
                }, self.domId('confirm-btn'));

                new Button({
                    label: 'Cancel',
                    onClick: onClickCancelButton,
                    className: 'primary'
                }, self.domId('cancel-btn'));
            };


            this.show = function () {
                self.createLayout();
                thisDialog.startup();

                async.series([
                    function (cb) {
                        self.onPreCreate(cb);
                    },
                    function (cb) {
                        self.createControls();
                        cb(null);
                    }], function ( /*err*/ ) {
                    thisDialog.show();
                });
            };


            function onClickCancelButton() {
                thisDialog.hide();
            }
        }


        return new SignUpDialog();
    });
