/**
 * statistics.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../../core/dibs');
var expressio = require('express.io');
var session = require('./session');

var router = new expressio.Router();
module.exports.router = router;


router.get('/statistics/:statisticsType', session.checkSession, function (req, res) {
    var type = req.param('statisticsType');
    var queryOpts = {};

    // process 'null' string on query option
    Object.keys(req.query).forEach(function (e) {
        if (req.query[e] && req.query[e] !== 'null') {
            queryOpts[e] = req.query[e];
        }
    });

    dibs.rpc.datamgr.queryStatistics(type, queryOpts, function (err, statistics) {
        if (err) {
            dibs.log.error(JSON.stringify(err));
            res.status(503).send(JSON.stringify(err.message));
        } else {
            res.send(JSON.stringify(statistics));
        }
    });
});
