/**
 * dep.pegjs
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 * 
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * Contributors:
 * - S-Core Co., Ltd
**/

start 
  = dl:depList {return dl;}
  / '' {return '';}
depList
  = d:dependency ',' l:depList {var list = l; list.unshift(d); return list}
  / d:dependency {return [d];}
dependency 
  = name:word b:base? o:os? {
      var dep = {};
      dep['packageName'] = name;
      if(b !== null && b !== '' ){
          dep['comp']= b[0]; 
          dep['baseVersion']= b[1]; 
      }
      if(o !== null && o !== ''){
          dep['os']= o;
      }
      return dep;
  }
os
  = '[' w:word ']' {return w;}
word
  = w:[-a-zA-Z0-9._]+ {return w.join('');}
base
  = '(' c:comp v:version ')' { return [c,v];}
version
  = l:number '.' r:version {return l + '.' + r;}
  / n:number {return n;}
number
  = n:[0-9]+ {return n.join('');}
comp
  = c:([<=>][<=>]?) {return c.join('');}
