/**
 * reverse-project.js
 * Copyright (c) 2000 - 2016 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

/**
 * Tizen reverse project plugin
 * @module models/tizen-project/reverse-project
 */

var dibs = require('../../core/dibs');
var Job = require('../dibs.model.common/job.js');
var TizenCommon = require('../org.tizen.common/tizen_common.js');
var TizenGitProject = require('./git-project.js');

module.exports.createJob = createJob;
module.exports.initializeJob = TizenGitProject.initializeJob;
module.exports.executeJob = TizenGitProject.executeJob;
module.exports.checkMutualExclusiveJob = TizenCommon.checkMutualExclusiveJob;
module.exports.saveBuildInfo = TizenGitProject.saveBuildInfo;

/**
 * Tizen reverse job that is specialized on tizen reverse project
 * @constructor
 * @augments module:models/job
 * @param {module:models/job~Job} baseJob - base job object
 */

function TizenReverseJob(baseJob) {
    Job.copy(this, baseJob);

    if (!this.options.packages) {
        this.options.packages = [];
    }
    this.compatJob = null;
    this.gitRepo = null;
    this.gitCommit = null;
    this.snapshot = null;
    this.distribution = null;

    // NOTE. Initializing on windows is very slow
    this.initEnvironments = dibs.projectTypes['Tizen-Reverse'].environments.filter(function (e) {
        return (e.indexOf('windows') === -1);
    });
}

/**
 * Create tizen reverse job instance
 * @function createJob
 * @param {string} userEmail - user email
 * @param {string} distName - distibution name
 * @param {string} prjName - project name
 * @param {string} prjType - project type
 * @param {string} environmentName - environment name
 * @param {string} parentId - parent Id
 * @param {string} distType - distibution type
 * @param {module:models/job.options} options - job options
 * @param {module:models/job~Job} baseJob - base job object
 * @memberOf module:models/tizen-project/git-project
 */

function createJob(userEmail, distName, prjName, prjType, environmentName, parentId, distType, options, callback) {
    Job.create(userEmail, distName, distType, options['PROJECT_NAME'], prjType, environmentName, parentId, null, options, function (err, newJob) {
        if (err) {
            return callback(err, null);
        } else {
            TizenCommon.checkReleasePhase(new TizenReverseJob(newJob), callback);
        }
    });
}
