# makeshortcut_linux.sh
# Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
# 
# Contact:
# DongHee Yang <donghee.yang@samsung.com>
# Sungmin Kim <sm.art.kim@samsung.com>
# Jiil Hyoun <jiil.hyoun@samsung.com>
# Jonghwan Park <iwin100.park@samsung.com>
# Kitae Kim <kt920.kim@samsung.com>
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Contributors:
# - S-Core Co., Ltd

#!/bin/bash -x

MENU_DIRECTORY_PATH=${HOME}/.local/share/desktop-directories/tizen-sdk-menu.directory

SHORTCUT_FILE_PATH=
EXEC_FILE_PATH=
ICON_PATH=

NAME=
COMMENT=

parseParameter()
{
	while [ $# -gt 0 ]
	do
		case $1 in
			-f|--filepath)
				shift
				SHORTCUT_FILE_PATH=$1
				echo "##SHORTCUT_FILE_PATH=$1"
				;;
			-e|--executefilepath)
				shift
				EXEC_FILE_PATH=$1
				echo "##SHORTCUT_EXECUTE_FILE_PATH=$1"
				;;
			-i|--iconpath)
				shift
				ICON_PATH=$1
				echo "##SHORTCUT_ICON_FILE_PATH=$1"
				;;
			-n|--name)
				shift
				NAME=$1
				echo "##SHORTCUT_NAME=$1"
				;;
			-c|--comment)
				shift
				COMMENT=$1
				echo "##SHORTCUT_COMMENT=$1"
				;;
			*)
				exit 12
				;;
		esac
		shift
    done
    echo "##SHORTCUT_END=";
}

##exist unconditionally
checkParameter()
{	
	if [ ! -e ${EXEC_FILE_PATH} ]; then
		exit 13
	fi
	
	if [ ! -e ${ICON_PATH} ]; then
		exit 13
	fi
}

makeShortcut()
{
	checkParameter
	
	UBUNTU_VER=`awk 'BEGIN {FS="="}; /DISTRIB_RELEASE.*/ {print $2}' /etc/lsb-release`

	case ${UBUNTU_VER} in
		11.04)
			categories="Tizen SDK;Development;"
			;;
		11.10)
			categories="Tizen SDK;Development;"
			;;
		*)
			categories="Tizen SDK"
			;;
	esac

	if [ -e ${SHORTCUT_FILE_PATH} ]; then
		rm -rf ${SHORTCUT_FILE_PATH}
	fi

	## Create .desktop file 
	mkdir -p ${HOME}/.local/share/applications
	cat >> ${SHORTCUT_FILE_PATH} << END
[Desktop Entry]
Encoding=UTF-8
Version=1.0
Type=Application
Terminal=false
Comment=${COMMENT} 
Name=${NAME}
Categories=$categories
StartupNotify=true
NoDisplay=false
Icon=${ICON_PATH}
Exec=${EXEC_FILE_PATH}
END

	## Register .desktop file
	xdg-desktop-menu install ${MENU_DIRECTORY_PATH} ${SHORTCUT_FILE_PATH}
}

parseParameter "$@"

if [ "${SKIP_SHORTCUT}" != "YES" ]; then  
makeShortcut
fi
