/**
 * remote-repo.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var async = require('async');

var Repo = require('./repo.js');
var DError = require('../../core/exception.js');

module.exports.createRemoteRepo = createRemoteRepo;
module.exports.getRemoteDistribution = getRemoteDistribution;


function createRemoteRepo(repoURL, options) {

    if (repoURL === undefined || repoURL === null) {
        return null;
    } else {
        if (options === undefined) {
            options = {};
        }
        return Repo.createRepo(null, repoURL, options);
    }
}


function getRemoteDistribution(remoteURL, remoteDistName, options, callback) {

    // get remote repository
    var targetRepo = null;
    if (options.snapshotName === null || options.snapshotName) {
        targetRepo = createRemoteRepo(remoteURL, {
            distName: remoteDistName,
            snapshotName: options.snapshotName
        });
    } else {
        targetRepo = createRemoteRepo(remoteURL, {
            distName: remoteDistName
        });
    }

    if (targetRepo === null) {
        callback(new DError('TREPO007'), null);
        return;
    }

    async.waterfall([
        // open remote
        function (cb) {
            targetRepo.open(null, cb);
        },
        // search syncDist
        function (cb) {
            targetRepo.searchDistributions({
                distName: remoteDistName
            }, function (err, dists) {
                if (err) {
                    return cb(err, null);
                } else if (dists.length === 0) {
                    return cb(new DError('TREPO004', {
                        dist: remoteDistName
                    }), null);
                } else {
                    return cb(null, dists[0]);
                }
            });
        }
    ], function (err, dist) {
        callback(err, dist);
    });
}
