/**
 * junit-xml-format.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var DOMParser = require('xmldom').DOMParser;
var _ = require('underscore');
var fs = require('fs');
var extfs = require('fs-extra');
var path = require('path');
var async = require('async');
var os = require('os');


module.exports.parse = parse;


function parse(testsuiteName, srcPathDir, monitor, callback) {
    var resultFile = path.join(srcPathDir, testsuiteName + '.xml');

    if (!fs.existsSync(resultFile)) {
        return callback(new DError('TIZENTA005', {
            path: resultFile
        }));
    }

    fs.readFile(resultFile, function (err, buf) {
        if (!err) {
            callback(null, junitParser(buf.toString()));
        } else {
            callback(err, null);
        }
    });
}


/* JSON FORMAT
{
    name:
    hostname:
    timestamp:
    time:
    tests:
    failures:
    errors:
    testcase:[{
                name:
                classname:
                time:
                failure:{
                    message:
                    type:
                    log:
                }
    }]
}
*/
function junitParser(xmlString) {
    var doc = new DOMParser().parseFromString(xmlString);
    var json = {};

    // get testsuite
    var xmlDomTestsuite = doc.getElementsByTagName('testsuite')[0];
    json.name = xmlDomTestsuite.getAttribute('name');
    json.hostname = xmlDomTestsuite.getAttribute('hostname');
    json.timestamp = xmlDomTestsuite.getAttribute('timestamp');
    json.time = xmlDomTestsuite.getAttribute('time');
    json.tests = parseInt(xmlDomTestsuite.getAttribute('tests'), 10);
    json.failures = parseInt(xmlDomTestsuite.getAttribute('failures'), 10);
    json.errors = parseInt(xmlDomTestsuite.getAttribute('errors'), 10);

    var xmlDomTestcase = xmlDomTestsuite.getElementsByTagName('testcase');
    json.testcase = [];
    _.each(xmlDomTestcase, function (xml) {
        var testcase = {};
        testcase.name = xml.getAttribute('name');
        testcase.classname = xml.getAttribute('classname');
        testcase.time = xml.getAttribute('time');

        var xmlFailure = xml.getElementsByTagName('failure');
        if (xmlFailure.length > 0) {
            testcase.failure = {};
            testcase.failure.message = xmlFailure[0].getAttribute('message');
            testcase.failure.type = xmlFailure[0].getAttribute('type');
            testcase.failure.log = xmlFailure[0].textContent;
        }
        json.testcase.push(testcase);
    });
    return json;
}
