/**
 * sdk-not-installed-env.js
 * Copyright (c) 2000 - 2017 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var fs = require('fs');
var path = require('path');
var async = require('async');
var os = require('os');

var utils = require('../../lib/utils');
var FileSystem = require('../dibs.core/filesystem.js');
var Process = require('../dibs.core/process.js');

module.exports.setup = setup;


function setup(enviromentId, distName, distBaseURL, workspace, passwd, testDistName, monitor, callback) {
    async.series([
        function (cb) {
            removeSDKIfInstalled(monitor, cb);
        },
        function (cb) {
            cleanUpScreen(monitor, cb);
        }
    ], function (err) {
        callback(err);
    });
}


function removeSDKIfInstalled(monitor, callback) {
    var configDir = path.join(utils.getHomePath(), '.installmanager');
    var installDir = path.join(utils.getHomePath(), 'tizen-sdk');
    var dataDir = path.join(utils.getHomePath(), 'tizen-sdk-data');

    async.series([
        function (cb) {
            if (fs.existsSync(configDir)) {
                FileSystem.remove(configDir, cb);
            } else {
                cb(null);
            }
        },
        function (cb) {
            if (fs.existsSync(installDir)) {
                FileSystem.remove(installDir, cb);
            } else {
                cb(null);
            }
        },
        function (cb) {
            if (fs.existsSync(dataDir)) {
                FileSystem.remove(dataDir, cb);
            } else {
                cb(null);
            }
        }
    ], function (err) {
        callback(err);
    });
}


function cleanUpScreen(monitor, callback) {
    if (os.platform() === 'linux') {
        cleanUpScreenOnLinux(monitor, callback);
    } else {
        callback(null);
    }
}


function cleanUpScreenOnLinux(monitor, callback) {
    var run = Process.create('wmctrl',
        ['-k', 'on'],
        {},
        {
            onStdout: function (line) {
                monitor.updateProgress('   ' + line);
            },
            onStderr: function (line) {
                monitor.updateProgress({
                    log: '   ' + line,
                    logType: 'warn'
                });
            },
            onExit: function (code) {
                if (code !== 0) {
                    var error = new Error('Executing process for clean-up screen exited with code ' + code);
                    callback(error);
                } else {
                    callback(null);
                }
            }
        });

    // add process to monitor
    monitor.addProcess(run);
}
