/**
 * pkg-info.js
 * Copyright (c) 2000 - 2017 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

'use strict';

var _ = require('underscore');

function PkgInfo(packages) {
    if (_.isArray(packages) && packages.length > 0) {
        this.packages = packages;
        this.version = packages[0].version || undefined;
    } else {
        this.packages = [];
        this.version = undefined;
    }
}

PkgInfo.prototype.toString = toString;
PkgInfo.prototype.getPackageNameList = getPackageNameList;

module.exports = PkgInfo;

function toString() {
    var self = this;
    return _.map(self, function (pkg) {
        return pkg.toString();
    }).join('\n');
}

function getPackageNameList() {
    var self = this;
    return _.uniq(_.pluck(self.packages, 'name'));
}
