/**
 * dpkg-build.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var optimist = require('optimist');
var os = require('os');
var async = require('async');
var Monitor = require('../../lib/monitor.js');
var dibs = require('../../core/dibs.js');
var Builder = require('./pkg-builder.js');


// option parse & set
var argv = optimist.usage(
    'Usage: dpkg-build [OPTS]' + os.EOL
).alias({
    h: 'help'
})
    .describe('h', 'display help')
    .argv;

if (argv.h) {
    optimist.showHelp();
    process.exit(0);
}

// initialize DIBS
dibs.initialize();

// prepare monitor
var monitor = new Monitor({
    onProgress: function (info, cb) {
        if (info.logType && (info.logType === 'error' || info.logType === 'warn')) {
            console.log('(' + info.logType + ') ' + info.log);
        } else {
            console.log(info.log);
        }
    }
});


// create dibs package/plguin
Builder.build({}, process.cwd(), monitor, function (err) {
    if (!err) {
        console.log('Creating DIBS package/plugin succeeded!');
        process.exit(0);
    } else {
        console.log('Creating DIBS package/plugin failed!');
        console.error(err.message);
        process.exit(-1);
    }
});
