/**
 * tables.js
 * Copyright (c) 2016 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/


var sql = require('sql');

module.exports = {
    distributions: function () {
        return sql.define({
            name: 'distributions',
            columns: [
                'id', 'group_id', 'name', 'type',
                'status', 'access', 'sync', 'description',
                'notification_group_id'
            ]
                        // dibs.log.info(job);
        });
    },

    projects: function () {
        return sql.define({
            name: 'projects',
            columns: [
                'id', 'distribution_id', 'name', 'type',
                'status', 'notification_group_id'
            ]
        });
    },

    environments: function () {
        return sql.define({
            name: 'environments',
            columns: [
                'id', 'name', 'description'
            ]
        });
    },

    notifications: function () {
        return sql.define({
            name: 'notifications',
            columns: [
                'id', 'notification_group_id', 'event', 'method',
                'target_type', 'target_user_id', 'target_group_id', 'target_data'
            ]
        });
    },

    jobs: function () {
        return sql.define({
            name: 'jobs',
            columns: [
                'id', 'user_email', 'distribution_name', 'distribution_type',
                'project_name', 'project_type', 'environment_name', 'parent_id',
                'type', 'status', 'start_time', 'end_time',
                'error_code', 'snapshot_name', 'description', 'init_server_id',
                'exec_server_id', 'approval_id', 'status_info'
            ]
        });
    },

    approvals: function () {
        return sql.define({
            name: 'approvals',
            columns: [
                'id', 'user_id', 'approval_type', 'subject',
                'contents', 'summary', 'submission_date', 'submission_status'
            ]
        });
    },

    servers: function () {
        return sql.define({
            name: 'servers',
            columns: [
                'id', 'type', 'parent_id', 'os_type',
                'host', 'port', 'domain_name', 'description'
            ]
        });
    },

    users: function () {
        return sql.define({
            name: 'users',
            columns: [
                'id', 'name', 'email', 'password_hash',
                'password_salt', 'image_id', 'status'
            ]
        });
    },

    groups: function () {
        return sql.define({
            name: 'groups',
            columns: [
                'id', 'name', 'parent_id', 'type', 'status', 'description'
            ]
        });
    }
};