/**
 * remote.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../core/dibs');


// callback( err )
module.exports.addImageFromFile = function (path, name, callback) {
    dibs.thisServer.addImageFromFileInternal(path, name, callback);
};

// callback( err, image )
module.exports.searchImage = function (cond, callback) {
    dibs.thisServer.searchImageInternal(cond, callback);
};

// callback( err )
module.exports.addUser = function (email, name, password_hash, password_salt, options, callback) {
    dibs.thisServer.addUserInternal(email, name, password_hash, password_salt, options, callback);
};

// callback( err, user )
module.exports.updateUser = function (user, callback) {
    dibs.thisServer.updateUserInternal(user, callback);
};

// callback( err )
module.exports.removeUser = function (userId, callback) {
    dibs.thisServer.removeUserInternal(userId, callback);
};

// callback( err, user )
module.exports.resetUserPassword = function (userId, callback) {
    dibs.thisServer.resetUserPasswordInternal(userId, callback);
};

// callback( err, users )
module.exports.searchUsers = function (cond, callback) {
    dibs.thisServer.searchUsersInternal(cond, callback);
};

// callback( err, users )
module.exports.searchUsersByGroupName = function (groupName, callback) {
    dibs.thisServer.searchUsersByGroupNameInternal(groupName, callback);
};

// callback( err, group )
module.exports.addUserGroup = function (name, type, description, options, callback) {
    dibs.thisServer.addUserGroupInternal(name, type, description, options, callback);
};

// callback( err )
module.exports.removeUserGroup = function (groupId, callback) {
    dibs.thisServer.removeUserGroupInternal(groupId, callback);
};

// callback( err, user )
module.exports.updateUserGroup = function (group, callback) {
    dibs.thisServer.updateUserGroupInternal(group, callback);
};

// callback( err, groups )
module.exports.searchUserGroups = function (cond, callback) {
    dibs.thisServer.searchUserGroupsInternal(cond, callback);
};

// callback( err, groups )
module.exports.searchUserGroupsInfo = function (email, callback) {
    dibs.thisServer.searchUserGroupsInfoInternal(email, callback);
};


// callback( err )
module.exports.addEnvironment = function (id, name, description, options, callback) {
    dibs.thisServer.addEnvironmentInternal(id, name, description, options, callback);
};

// callback( err )
module.exports.updateEnvironment = function (environment, callback) {
    dibs.thisServer.updateEnvironmentInternal(environment, callback);
};

// callback( err, users )
module.exports.searchEnvironments = function (cond, callback) {
    dibs.thisServer.searchEnvironmentsInternal(cond, callback);
};

// callback( err, users )
module.exports.deleteEnvironments = function (cond, callback) {
    dibs.thisServer.deleteEnvironmentsInternal(cond, callback);
};

// callback( err )
module.exports.addProject = function (name, type, options, environments, triggers, notifications, distName, callback) {
    dibs.thisServer.addProjectInternal(name, type, options, environments, triggers, notifications, distName, callback);
};

// callback( err )
module.exports.removeProject = function (name, distName, callback) {
    dibs.thisServer.removeProjectInternal(name, distName, callback);
};

// callback( err )
module.exports.updateProject = function (project, callback) {
    dibs.thisServer.updateProjectInternal(project, callback);
};


// callback( err, projects )
module.exports.searchProjects = function (cond, callback) {
    dibs.thisServer.searchProjectsInternal(cond, callback);
};

// callback( err, projects )
module.exports.searchProjectsWithTreeModel = function (cond, callback) {
    dibs.thisServer.searchProjectsWithTreeModelInternal(cond, callback);
};

// callback( err, projects )
module.exports.searchProjectPrivilege = function (cond, callback) {
    dibs.thisServer.searchProjectPrivilegeInternal(cond, callback);
};


// create new job and add it into DB and return it
// callback( err, job )
module.exports.addJob = function (userEmail, distName, prjName, environmentName, parentId, options, callback) {
    dibs.thisServer.addJobInternal(userEmail, distName, prjName, environmentName, parentId, options, callback);
};


// callback( err, result )
module.exports.checkPrivilege = function (resource, method, options, userEmail, callback) {
    dibs.thisServer.checkPrivilegeInternal(resource, method, options, userEmail, callback);
};


module.exports.checkJobPrivilege = function (userEmail, distName, prjName, options, callback) {
    dibs.thisServer.checkJobPrivilegeInternal(userEmail, distName, prjName, options, callback);
};


// callback( err, jobs )
module.exports.searchJobs = function (cond, callback) {
    dibs.thisServer.searchJobsInternal(cond, callback);
};

// callback( err, jobs )
module.exports.searchJobCount = function (cond, callback) {
    dibs.thisServer.searchJobCountInternal(cond, callback);
};


// callback( err )
module.exports.updateJob = function (job, callback) {
    dibs.thisServer.updateJobInternal(job, callback);
};


// callback( err, dist )
module.exports.addDistribution = function (groupName, name, type, status, access, sync, description, options, callback) {
    dibs.thisServer.addDistributionInternal(groupName, name, type, status, access, sync, description, options, callback);
};

// callback( err )
module.exports.removeDistribution = function (name, callback) {
    dibs.thisServer.removeDistributionInternal(name, callback);
};

// callback( err, dist )
module.exports.updateDistribution = function (dist, callback) {
    dibs.thisServer.updateDistributionInternal(dist, callback);
};

// callback( err, dists )
module.exports.searchDistributions = function (cond, callback) {
    dibs.thisServer.searchDistributionsInternal(cond, callback);
};

// callback( err, dist )
module.exports.addNotification = function (event, method, type, target, groupId, description, callback) {
    dibs.thisServer.addNotificationInternal(event, method, type, target, groupId, description, callback);
};

// callback( err, dist )
module.exports.updateNotification = function (notification, callback) {
    dibs.thisServer.updateNotificationInternal(notification, callback);
};

// callback( err, dist )
module.exports.searchNotification = function (condition, callback) {
    dibs.thisServer.searchNotificationInternal(condition, callback);
};

// callback( err, dist )
module.exports.removeNotification = function (condition, callback) {
    dibs.thisServer.removeNotificationInternal(condition, callback);
};

module.exports.queryStatistics = function (stype, options, callback) {
    dibs.thisServer._queryStatistics(stype, options, callback);
};

// callback( err, trigger_id )
module.exports.addTrigger = function (name, type, status, serverType, data, callback) {
    dibs.thisServer.addTriggerInternal(name, type, status, serverType, data, callback);
};

// callback( err )
module.exports.updateTrigger = function (trigger, callback) {
    dibs.thisServer.updateTriggerInternal(trigger, callback);
};

// callback( err, triggers )
module.exports.searchTriggers = function (condition, callback) {
    dibs.thisServer.searchTriggersInternal(condition, callback);
};

// callback( err )
module.exports.deleteTrigger = function (triggerId, callback) {
    dibs.thisServer.deleteTriggerInternal(triggerId, callback);
};

// approval managerment
// callback( err, approval_id )
module.exports.addApproval = function (email, subject, contents, summary, approvalRoutes, type, callback) {
    dibs.thisServer.addApprovalInternal(email, subject, contents, summary, approvalRoutes, type, callback);
};

// callback( err )
module.exports.updateApproval = function (approval, callback) {
    dibs.thisServer.updateApprovalInternal(approval, callback);
};

// callback( err, approvals )
module.exports.searchApprovals = function (condition, callback) {
    dibs.thisServer.searchApprovalsInternal(condition, callback);
};

// callback( err )
module.exports.deleteApproval = function (approvalId, callback) {
    dibs.thisServer.deleteApprovalInternal(approvalId, callback);
};

// server managerment
// callback( err, server )
module.exports.addServer = function (id, type, parentId, osType, host, port, domainName, description, information, callback) {
    dibs.thisServer.addServerInternal(id, type, parentId, osType, host, port, domainName, description, information, callback);
};

// callback( err )
module.exports.updateServer = function (server, callback) {
    dibs.thisServer.updateServerInternal(server, callback);
};

// callback( err, servers )
module.exports.searchServers = function (condition, callback) {
    dibs.thisServer.searchServersInternal(condition, callback);
};

// callback( err, servers )
module.exports.searchAllServers = function (callback) {
    dibs.thisServer.searchAllServersInternal(callback);
};

// callback( err )
module.exports.deleteServer = function (id, callback) {
    dibs.thisServer.deleteServerInternal(id, callback);
};

// callback( err, snapshot )
module.exports.addSnapshot = function (name, distName, type, time, status, attribute, path, description, options, callback) {
    dibs.thisServer.addSnapshotInternal(name, distName, type, time, status, attribute, path, description, options, callback);
};

// callback( err, snapshots )
module.exports.searchSnapshots = function (condition, callback) {
    dibs.thisServer.searchSnapshotsInternal(condition, callback);
};

// callback( err )
module.exports.updateSnapshot = function (snapshot, callback) {
    dibs.thisServer.updateSnapshotInternal(snapshot, callback);
};

// callback( err )
module.exports.updateSnapshotStatus = function (snapshot, callback) {
    dibs.thisServer.updateSnapshotStatusInternal(snapshot, callback);
};

// callback( err )
module.exports.deleteSnapshot = function (id, callback) {
    dibs.thisServer.deleteSnapshotInternal(id, callback);
};

// callback( err, artifact )
module.exports.addArtifact = function (name, distName, type, version, environment,
        attribute, status, fileName, path, size, checksum, description, options, callback) {
    dibs.thisServer.addArtifactInternal(name, distName, type, version, environment,
        attribute, status, fileName, path, size, checksum, description, options, callback);
};

// callback( err, artifacts )
module.exports.searchArtifacts = function (condition, callback) {
    dibs.thisServer.searchArtifactsInternal(condition, callback);
};

// callback( err )
module.exports.updateArtifact = function (snapshot, callback) {
    dibs.thisServer.updateArtifactInternal(snapshot, callback);
};

// callback( err )
module.exports.deleteArtifact = function (id, callback) {
    dibs.thisServer.deleteArtifactInternal(id, callback);
};

/**
 * @function addUser
 * @param {string} email - email
 * @param {string} name - name
 * @param {string} password_hash - password_hash
 * @param {string} password_salt - password_salt
 * @param {string} options - options
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function searchUsers
 * @param {string} cond - cond
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function addProject
 * @param {string} name - name
 * @param {string} type - type
 * @param {string} options - options
 * @param {string} distName - distName
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function searchProjects
 * @param {string} cond - cond
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function addJob
 * @param {string} prjName - prjName
 * @param {string} options - options
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function searchJobs
 * @param {string} cond - cond
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function updateJob
 * @param {string} job - job
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function addDistribution
 * @param {string} name - name
 * @param {string} options - options
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @function searchDistributions
 * @param {string} cond - cond
 * @param {module:lib/utils.callback_error} callback - callback
 * @memberOf module:servers/data-manager/remote
 */


/**
 * @module servers/data-manager/remote
 */
