/**
 * login.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

require([
    'dijit/layout/BorderContainer',
    'dijit/layout/ContentPane',
    'dojo/cookie',
    'dojo/dom',
    'dojo/ready'
], function (BorderContainer, ContentPane, Cookie, Dom, Ready) {
    Ready(function () {
        var cookieEmail = Cookie('userEmail');
        if (cookieEmail) {
            Dom.byId('login-email').value = cookieEmail;
            Dom.byId('login-remember').checked = true;
        }
    });
});

function onClickRemember() {
    require(['dojo/dom'],
        function (Dom) {
            if (Dom.byId('login-remember').checked === true) {
                Dom.byId('login-remember').checked = false;
            } else {
                Dom.byId('login-remember').checked = true;
            }
        });
}

function onClickLoginButton() {
    require([
        'dojo/cookie',
        'dojo/dom',
        'dijit/registry',
        'javascripts/session-controller.js',
        'javascripts/message-dialog.js'
    ], function (Cookie, Dom, Registry, sessionController, MessageDialog) {
        var email = Dom.byId('login-email').value;
        var password = Dom.byId('login-password').value;

        sessionController.login(email, password, function (status, res) {
            res = JSON.parse(res);
            var dialog = null;
            switch (status) {
            case 200:
                if (Dom.byId('login-remember').checked === true && email) {
                    Cookie('userEmail', email, 7);
                } else {
                    Cookie('userEmail', email, -1);
                }

                if (res.status !== 'OPEN') {
                    dialog = new MessageDialog('This account needs the permission of the administrator.', {
                        title: 'Warning'
                    });
                    dialog.show();
                } else {
                    location.replace('dibs.html#dash-board');
                }

                break;
            case 401:
                dialog = new MessageDialog('Incorrect password!', {
                    title: 'Error'
                });
                dialog.show();
                break;
            case 404:
                dialog = new MessageDialog('Invalid email!', {
                    title: 'Error'
                });
                dialog.show();
                break;
            default:
                dialog = new MessageDialog('Internal server error!', {
                    title: 'Error'
                });
                dialog.show();
                break;
            }
        });
    });
}

function onClickSignupButton() {
    require(['javascripts/sign-up-dialog.js', 'dojo/on'], function (SignUpDialog) {
        SignUpDialog.show();
    });
}

function onKeyPressInput(evt) {
    require(['dojo/keys'], function (Keys) {
        var keyCode = evt.charCode || evt.keyCode;
        if (keyCode === Keys.ENTER) {
            onClickLoginButton();
        }
    });
}
