/**
 * message-dialog.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

define([
    'dijit/Dialog',
    'dijit/form/Button',
    'dojo/dom',
    'dojo/dom-attr',
    'dojo/domReady!'
],
    function (Dialog, Button, dom, domAttr) {

        var index = 0;

        function MessageDialog(msg, options) {
            var self = this;
            index++;

            var dialog = null;

            if (options === undefined || options === null) {
                options = {};
            }
            if (options.buttonType === undefined || options.buttonType === null) {
                options.buttonType = 'OK';
            }

            var contentId = 'dibs.messageDialog.content.' + index;
            var oKBtnId = 'dibs.messageDialog.btn.ok.' + index;
            var cancelBtnId = 'dibs.messageDialog.btn.cancel.' + index;

            // create dialog
            (function createLayout() {
                var title = '';
                if (options.title !== undefined) {
                    title = options.title;
                }

                var layout = null;
                switch (options.buttonType) {
                case 'OK':
                    layout = '<div class=\'po_cont\' id=' + contentId + '></div>' +
                        '<div class=\'button_group center\'>' +
                        '<button id=\'' + oKBtnId + '\' type=\'submit\'></button>' +
                        '<br style=\'clear:right;\' />' +
                        '</div>';
                    break;
                case 'OKCANCEL':
                    layout = '<div class=\'po_cont\' id=' + contentId + '></div>' +
                        '<div class=\'button_group center\'>' +
                        '<button id=\'' + cancelBtnId + '\' type=\'button\'></button>' +
                        '<button id=\'' + oKBtnId + '\' type=\'submit\'></button>' +
                        '<br style=\'clear:right;\' />' +
                        '</div>';
                    break;
                case 'NONE':
                    layout = '<div class=\'po_cont\' id=' + contentId + '></div>';
                    break;
                default:
                    layout = '<div class=\'po_cont\' id=' + contentId + '></div>' +
                        '<div class=\'button_group center\'>' +
                        '<button id=\'' + oKBtnId + '\' type=\'submit\'></button>' +
                        '<br style=\'clear:right;\' />' +
                        '</div>';
                    break;
                }

                dialog = new Dialog({
                    title: title,
                    style: 'width:400px;height:auto;',
                    content: '<div class="ui_dialog_wrap">' + layout + '</div>'
                });
                dialog.startup();
            })();


            this.dialog = dialog;
            this.show = function (handler) {

                // Update message
                dom.byId(contentId).innerHTML = msg;

                // Append 'submit' event handler
                dialog.set('execute', function () {
                    if (handler !== undefined && handler.onOK !== undefined) {
                        handler.onOK();
                    }
                });
                // Append 'cancel' event handler
                if (handler !== undefined && handler.onCancel !== undefined) {
                    dialog.set('onCancel', function () {
                        dialog.hide();
                        handler.onCancel();
                    });
                }

                var okBtn = null;
                var cancelBtn = null;
                switch (options.buttonType) {
                case 'OK':
                    oKBtn = new Button({
                        label: 'OK',
                        type: 'submit',
                        className: 'primary'
                    }, oKBtnId);
                    break;
                case 'OKCANCEL':
                    oKBtn = new Button({
                        label: 'OK',
                        type: 'submit',
                        className: 'primary'
                    }, oKBtnId);
                    cancelBtn = new Button({
                        label: 'Cancel',
                        className: 'primary',
                        onClick: function () {
                            dialog.hide();
                            if (handler !== undefined && handler.onCancel !== undefined) {
                                handler.onCancel();
                            }
                        }
                    }, cancelBtnId);
                    break;
                case 'NONE':
                    break;
                default:
                    oKBtn = new Button({
                        label: 'OK',
                        type: 'submit',
                        className: 'primary'
                    }, oKBtnId);
                    break;
                }

                dialog.show();
            };
        }

        return MessageDialog;
    });
