/**
 * image-button.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

define(['dojo/_base/declare',
    'dijit/_WidgetBase',
    'dijit/_TemplatedMixin',
    'dojo/text!widgets/button/templates/button.html',
    'dojo/dom-style',
    'dojo/mouse',
    'dojo/on',
    'dojo/_base/fx',
    'dojo/_base/lang'],
    function (declare, _WidgetBase, _TemplatedMixin, template, domStyle, mouse, on, baseFx, lang) {
        return declare([_WidgetBase, _TemplatedMixin], {
            orgImg: require.toUrl('widgets/button/images/default_button.png'),
            clickImg: require.toUrl('widgets/button/images/default_button.png'),
            overImg: require.toUrl('widgets/button/images/default_button.png'),
            selImg: require.toUrl('widgets/button/images/default_button.png'),
            checked: false,

            // Our template - important!
            templateString: template,

            baseClass: 'imageButtonWidget',

            mouseAnim: null,

            postCreate: function () {
                var self = this;
                var domNode = this.domNode;

                this.inherited(arguments);

                this.own(
                    on(domNode, 'click', lang.hitch(this, 'onClick'))
                );

                this.own(
                    on(domNode, mouse.enter, lang.hitch(this, '_onOverButtonImage'))
                );
                this.own(
                    on(domNode, mouse.leave, lang.hitch(this, '_onLeaveButtonImage'))
                );
            },

            onClick: function () {},

            _setOrgImgAttr: function (imagePath) {
                if (imagePath !== '') {
                    this._set('orgImg', imagePath);
                }
            },

            _setOverImgAttr: function (imagePath) {
                if (imagePath !== '') {
                    this._set('overImg', imagePath);
                }
            },

            _setSelImgAttr: function (imagePath) {
                if (imagePath !== '') {
                    this._set('selImg', imagePath);
                }
            },

            _setOnClickAttr: function (callback) {
                this._set('onClick', function () {
                    this.imageNode.src = this.clickImg;
                    callback();
                });
            },

            _setCheckedAttr: function (isChecked) {
                this._set('checked', isChecked);
                if (isChecked) {
                    this.imageNode.src = this.selImg;
                } else {
                    this.imageNode.src = this.orgImg;
                }
            },
            _onOverButtonImage: function (callback) {
                this.imageNode.src = this.overImg;
            },

            _onLeaveButtonImage: function (callback) {
                if (this.checked) {
                    this.imageNode.src = this.selImg;
                } else {
                    this.imageNode.src = this.orgImg;
                }
            }
        });
    });
