/**
 * release.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var dibs = require('../../../core/dibs.js');
var expressio = require('express.io');
var session = require('./session');
var _ = require('underscore');

var router = new expressio.Router();

module.exports.router = router;

router.get('/distributions/:distName/releases', function (req, res) {
    var distName = req.param('distName');

    dibs.rpc.repo.searchReleases(distName, {
    }, function (err, releases) {
        if (err) {
            dibs.log.error(err);
            res.status(503).send(JSON.stringify(err.message));
        } else {
            // sort by descending order
            var sortedReleases = releases.sort(function (rel1, rel2) {
                var relDate1 = new Date(rel1.creationTime);
                var relDate2 = new Date(rel2.creationTime);
                if (relDate1 < relDate2) {
                    return 1;
                } else if (relDate1 > relDate2) {
                    return -1;
                } else {
                    return 0;
                }
            });
            res.send(sortedReleases);
        }
    });
});


router.get('/distributions/:distName/releases/:releaseName',
    session.checkSession, function (req, res) {

        var distName = req.param('distName');
        var releaseName = req.param('releaseName');
        var email = req.session.email;

        dibs.rpc.repo.getRelease(releaseName, distName, function (err, release) {
            if (err) {
                dibs.log.error(err);
                res.status(503).send(JSON.stringify(err.message));
            } else {
                res.send(release);
            }
        });
    });


router.delete('/distributions/:distName/releases/:releaseName',
    session.checkSession, function (req, res) {

        var distName = req.param('distName');
        var releaseName = req.param('releaseName');
        var email = req.session.email;

        dibs.rpc.repo.removeRelease(releaseName, distName, {}, function (err, release) {
            if (err) {
                dibs.log.error(err);
                res.status(503).send(JSON.stringify(err.message));
            } else {
                res.send();
            }
        });
    });

router.put('/distributions/:distName/releases/:releaseName',
    session.checkSession, function (req, res) {

        var distName = req.param('distName');
        var releaseName = req.param('releaseName');

        var updatedRel = req.body.release;
        var options = req.body.options;

        dibs.rpc.repo.getRelease(releaseName, distName, function (err, release) {
            if (err) {
                dibs.log.error(err);
                res.status(503).send(JSON.stringify(err.message));
            } else {
                if (updatedRel.releaseNote) {
                    release.releaseNote = updatedRel.releaseNote;
                }
                if (updatedRel.releaseFiles) {
                    release.releaseFiles = updatedRel.releaseFiles;
                }

                dibs.rpc.repo.updateRelease(release, distName, {
                    releaseFiles: options.releaseFiles
                }, function (err) {
                    if (err) {
                        dibs.log.error(err);
                        res.status(503).send(JSON.stringify(err.message));
                    } else {
                        res.send();
                    }
                });
            }
        });
    });
