# makeshortcut_macos.sh
# Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
# 
# Contact:
# DongHee Yang <donghee.yang@samsung.com>
# Sungmin Kim <sm.art.kim@samsung.com>
# Jiil Hyoun <jiil.hyoun@samsung.com>
# Jonghwan Park <iwin100.park@samsung.com>
# Kitae Kim <kt920.kim@samsung.com>
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Contributors:
# - S-Core Co., Ltd

#!/bin/bash -x

TARGET_DIR=
thePath=
INSTALLED_DIR_NAME=

parseParameter()
{
	while [ $# -gt 0 ]
	do
		case $1 in
			-t|--targetDir)
				shift
				TARGET_DIR=$1
				;;
			-in|--installedDirName)
				shift
				INSTALLED_DIR_NAME=$1
				;;
			-n|--name)
				shift
				NAME=$1
				echo "##SHORTCUT_NAME=$1"
				;;
			-s|--installedAppDir)
				shift
				thePath=$1
				echo "##SHORTCUT_EXECUTE_FILE_PATH=$1"
				;;
			*)
				exit 12
				;;
		esac
		shift
	done
    echo "##SHORTCUT_END="
}
parseParameter "$@"

if [ "${SKIP_SHORTCUT}" = "YES" ]; then
    exit 0
fi

if [ "$INSTALLED_DIR_NAME" != "" ]; then
	TARGET_DIR=$TARGET_DIR/$INSTALLED_DIR_NAME	
fi

if [ ! -e ${TARGET_DIR} ]; then
	mkdir ${TARGET_DIR}
fi

osascript <<END
tell application "Finder"
    make new alias at POSIX file "$TARGET_DIR" to POSIX file "$thePath"
end tell

END
