'  makeshortcut_windows.vbs
'  Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
'  
'  Contact:
'  DongHee Yang <donghee.yang@samsung.com>
'  Sungmin Kim <sm.art.kim@samsung.com>
'  Jiil Hyoun <jiil.hyoun@samsung.com>
'  Jonghwan Park <iwin100.park@samsung.com>
'  Kitae Kim <kt920.kim@samsung.com>
'  
'  Licensed under the Apache License, Version 2.0 (the "License");
'  you may not use this file except in compliance with the License.
'  You may obtain a copy of the License at
'  
'  http://www.apache.org/licenses/LICENSE-2.0
'  
'  Unless required by applicable law or agreed to in writing, software
'  distributed under the License is distributed on an "AS IS" BASIS,
'  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
'  See the License for the specific language governing permissions and
'  limitations under the License.
'  
'  Contributors:
'  - S-Core Co., Ltd

set WshShell = WScript.CreateObject("WScript.Shell")
Set fso = CreateObject ("Scripting.FileSystemObject")
Set stdout = fso.GetStandardStream (1)
Set stderr = fso.GetStandardStream (2)

programsPath = wshShell.SpecialFolders("Programs")
TizenSDKPath = programsPath & "\Tizen SDK"

shortcutName = Wscript.Arguments.Named("shortcut") 
fileName = Wscript.Arguments.Named("target")
iconPath = Wscript.Arguments.Named("icon") 

stdout.WriteLine "##SHORTCUT_NAME=" & shortcutName
stdout.WriteLine "##SHORTCUT_EXECUTE_FILE_PATH=" & fileName
stdout.WriteLine "##SHORTCUT_ICON_FILE_PATH=" & iconPath
stdout.WriteLIne "##SHORTCUT_END="

skipShortcut = WshShell.ExpandEnvironmentStrings("%SKIP_SHORTCUT%")
If skipShortcut = "YES" Then
    WScript.Quit 0
End If

set objFSO = CreateObject("Scripting.FileSystemObject")
if not objFSO.FolderExists(TizenSDKPath) Then
	objFSO.CreateFolder(TizenSDKPath)
End If

linkFilePath = TizenSDKPath & "\" & shortcutName & ".lnk"

set filesys = CreateObject("Scripting.FileSystemObject")
set oShellLink = WshShell.CreateShortcut(linkFilePath)
oShellLink.TargetPath = fileName
oShellLink.IconLocation = iconPath
oShellLink.WorkingDirectory = filesys.GetParentFolderName(fileName)
oShellLink.WindowStyle = 1
oShellLink.Save
