/**
 * record.js
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var spawn = require('child_process').spawn;
var exec = require('child_process').exec;
var os = require('os');
var path = require('path');

module.exports.startRecord = startRecord;
module.exports.terminate = terminate;

function startRecord(dir, fileName, callback) {
    var options = [];
    var filePath = '';
    var cmd = '';

    switch (os.platform()) {
    case 'linux':
        cmd = 'recordmydesktop';
        if (fileName) {
            filePath = path.join(dir, fileName + '.ogv');
        } else {
            filePath = path.join(dir, 'out.ogv');
        }
        break;
    default:
        callback(new Error('unknown os platform : ' + os.platform()), null, filePath);
        return;
    }

    options = ['-o', filePath, '--quick-subsampling', '--fps', '10', '--v_quality=0', '--overwrite', '--v_bitrate=45000', '--on-the-fly-encoding'];
    checkRecorder(os.platform(), cmd, function (err) {
        if (err) {
            callback(new Error(cmd + ' program is not exist\n please install ' + cmd + 'program'), null, filePath);
        } else {
            callback(null, spawn(cmd, options, process.env), filePath);
        }
    });
}

function checkRecorder(os, cmd, callback) {
    switch (os) {
    case 'linux':
        exec(cmd + ' -h', process.env, function (error, stdout, stderr) {
            if (stdout.match('Usage: ')) {
                callback(null);
            } else {
                callback(new Error(cmd + ' program is not exist\n please install ' + cmd + 'program'));
            }
        });
        break;
    default:
        callback(new Error('unknown os platform : ' + os.platform()));
        return;
    }
}

function terminate(proc, logger, callback) {
    if (proc.pid) {
        proc.on('close', function () {
            callback(null);
        });
        proc.stdout.on('data', function (data) {
            logger(data.toString());
        });
        proc.kill('SIGTERM');
    } else {
        callback(new Error('record process not exist'));
    }
}

//var async = require('async');
//async.waterfall([
//        function(cb){
//            checkRecorder(os.platform(),"recordmydesktop",cb);
//        }
//        ],function(err){
//            console.log(err);
//        });
//
//var Nproc = null;
//async.waterfall([
//        function(cb){
//            startRecord(".","temp",cb);
//        },
//        function(proc, filePath, cb){
//            Nproc = proc;
//            setTimeout(function(){
//                cb(null);
//            },10000);
//        },
//        function(cb){
//            terminate(Nproc, console.log, cb);
//        }
//        ],function(){
//            console.log("Finished");
//        });
