/**
 * changelog.pegjs
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 * 
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * Contributors:
 * - S-Core Co., Ltd
**/

{
    var changeLogList = [];
    function changelogToString(){
        return "* " + this.version + "\n" + this.contents;
    }
}
start 
    = l:lineList [\n\r\t ]* {return changeLogList;}

lineList 
    = l:line n:newline ll:lineList { if(l[0] == "contents" && ll[0] == "contents"){ return ["contents",l[1]+n+ll[1]]}
    if(l[0] == "version") {changeLogList.unshift({version:l[1],contents:ll[1],toString:changelogToString}); return ["contents",""]; } }
    / line

line
    = '*'[ \t]*i:[0-9.]+[ \t]* {return ["version",i.join('')];}
    / s:[^\n\r]+ {return ["contents",s.join('')]}

newline
    = n:[\n\r]+ {return n.join("")}
