/**
 * pkg.pegjs
 * Copyright (c) 2000 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 * 
 * Contact:
 * DongHee Yang <donghee.yang@samsung.com>
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jiil Hyoun <jiil.hyoun@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * Contributors:
 * - S-Core Co., Ltd
**/

{
    var _ = require('underscore'); 
    function mapHeader(pkgList){
      if(pkgList[0].Package == undefined){
          return _.map(_.rest(pkgList),function(pkg){
                  return _.extend(pkg,pkgList[0]);
                  });
      }
      else{ return pkgList; }
    }
    function addChangelog(pkgList, changelog){
        return _.map(mapHeader(pkgList),function(pkg){
                pkg.Changelog = changelog;
                return pkg;
                });
    }
}
start
  = p:pkgList newLine* c:changelog {return addChangelog(p,c);}
  / p:pkgList newLine* { return mapHeader(p); }
  / newLine* {return {};}
pkgList
  = p:pkg newLine newLine l:pkgList {l.unshift(p); return l;}
  / p:pkg newLine {return [p];}
  / p:pkg {return [p];}
pkg
  = t:tuple newLine p:pkg {return _.extend(t,p)}
  / tuple
tuple
  = k:key s:stringList {
      var sprime = s.trim(''); 
      if(sprime == ""){ return {};}
      else{var attr = {}; attr[k] = sprime; return attr;}
  }
  / k:key {return {}}
key
  = k:[-a-zA-z0-9]+ [ \t]* ':' {return k.join("");} 
stringList
  = s:string newLine ' ' l:stringList {return s + '\n' + l;}
  / newLine ' ' l:stringList {return l;}
  / string
changelog
  = '#Change log' [ \t]* newLine c:(.*) {return c.join('');}
multiemptyLine
  = ' .' {return "";}
string 
  = !key!changelog s:([^\n\r]+) {var str = s.join(""); return (str === '.')? "": str;}
newLine
  = '\n'
  / '\r' newLine
