/**
 * activator.js
 * Copyright (c) 2000 - 2017 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Sungmin Kim <sm.art.kim@samsung.com>
 * Jonghwan Park <iwin100.park@samsung.com>
 * Kitae Kim <kt920.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
**/

var BaseActivator = require('../../core/plugin/base-activator.js');

function Activator() {
    /**
     * check environment is true or false
     * @function checkEnv
     * @param {object} environment - key:value  hash list
     * @param {module:core/base-server.BaseServer} server - server object
     * @param {module:lib/utils.callback_err_bool} callback - callback
     * @memberOf module:models/tizen-common/project
     */
    this.checkNothing = function (server, callback) {
        callback(true);
    };
}

Activator.prototype = new BaseActivator();

module.exports = new Activator();
