/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import ttrace.handlers.CheckboxManager;
import ttrace.handlers.ComboWrapper;
import ttrace.handlers.CommandHandler;
import ttrace.handlers.Environment;
import ttrace.handlers.SDBconnection;
import ttrace.handlers.StateManager;
import ttrace.handlers.StringHandler;
import ttrace.handlers.TTraceAsyncState;
import ttrace.handlers.TTraceDoneState;
import ttrace.handlers.TTraceNotConnectedState;
import ttrace.handlers.TTraceNotOneTargetState;
import ttrace.handlers.TTraceNotSupportedState;
import ttrace.handlers.TTraceReadyState;
import ttrace.handlers.TTraceWaitingState;

public class GetInput
extends ApplicationWindow {
    private static GetInput getInput;
    private static boolean running;

    private GetInput() {
        super(null);
    }

    public static GetInput getInstance() {
        if (getInput == null) {
            getInput = new GetInput();
        }
        return getInput;
    }

    public void run() {
        if (!running) {
            running = true;
            this.setBlockOnOpen(true);
            this.open();
            running = false;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("T-trace for Tizen Studio");
        ShellListener shellListener = new ShellListener(){

            public void shellActivated(ShellEvent arg0) {
            }

            public void shellClosed(ShellEvent arg0) {
                System.out.println("ShellEventManager::::Shell closed!!!!");
                StateManager.stopSyncThread();
                StateManager.stopAsyncThread();
                System.out.println("ShellEventManager::::Thread stopped!!!!");
            }

            public void shellDeactivated(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellIconified(ShellEvent arg0) {
            }
        };
        shell.addShellListener(shellListener);
    }

    protected Control createContents(Composite parent) {
        System.out.println("GetInput: createContents");
        Shell shell = parent.getShell();
        Environment env = Environment.getInstance();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Group group_ftrace = new Group(composite, 4);
        group_ftrace.setText("Tags(Kernel)");
        group_ftrace.setLayout((Layout)new RowLayout(512));
        group_ftrace.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        CheckboxManager.initCheckboxesFtrace(group_ftrace);
        Group group_ttrace = new Group(composite, 4);
        group_ttrace.setText("Tags(Platform)");
        group_ttrace.setLayout((Layout)new RowLayout(512));
        group_ttrace.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        CheckboxManager.initCheckboxesTtrace(group_ttrace);
        Button resetButton = new Button(composite, 2);
        GridData data = new GridData(768);
        resetButton.setText("Reset");
        resetButton.setLayoutData((Object)new GridData(768));
        data.horizontalSpan = 2;
        resetButton.setLayoutData((Object)data);
        resetButton.setBackground(new Color((Device)Display.getCurrent(), 240, 240, 240));
        resetButton.setVisible(true);
        Composite compOptions = new Composite(composite, 0);
        compOptions.setLayout((Layout)new GridLayout(1, false));
        compOptions.setLayoutData((Object)new GridData(1808));
        Group groupTimes = new Group(compOptions, 32);
        groupTimes.setLayout((Layout)new RowLayout(512));
        groupTimes.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label timeLabel = new Label((Composite)groupTimes, 16384);
        timeLabel.setText("Time(secs)");
        String[] strTimes = new String[]{"10", "30", "60", "Manual"};
        ComboWrapper comboTimes = new ComboWrapper((Composite)groupTimes, strTimes);
        Label label_buffer = new Label((Composite)groupTimes, 16384);
        label_buffer.setText("Buffer(kb)");
        String[] strBuffers = new String[]{"1024", "2048", "4096", "10240"};
        ComboWrapper comboBuffers = new ComboWrapper((Composite)groupTimes, strBuffers);
        StringHandler.strHandler(resetButton, comboTimes, comboBuffers);
        Button show = new Button(composite, 72);
        show.setText("Ready to trace");
        show.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        parent.pack();
        env = Environment.getInstance();
        boolean isChrome = env.isChromeAvailable();
        if (!isChrome) {
            show.setText("Could not find \nChrome Browser");
            MessageDialog.openInformation((Shell)shell, (String)"Insufficient pre-requisition", (String)"Could not find Chrome browser\n\nPlease install Chrome browser and fill the path to\n'Preferences->Tizen Studio->Web->Chrome'");
            show.setEnabled(false);
            return composite;
        }
        String isPython = env.isPythonAvailable();
        if (!isPython.startsWith("TRUE")) {
            show.setText("Could not find \nPython 2.7.x");
            if (isPython.startsWith("FALSE")) {
                MessageDialog.openInformation((Shell)shell, (String)"Insufficient pre-requisition", (String)"Could not find Python\n\nPlease install Python v2.7.x and\ncheck the system variable \"PATH\" is set properly");
            } else {
                MessageDialog.openInformation((Shell)shell, (String)"Insufficient pre-requisition", (String)("T-trace is not compatible with " + isPython + "\nPlease install Python v2.7.x"));
            }
            show.setEnabled(false);
            return composite;
        }
        StateManager stateManager = StateManager.getInstance();
        TTraceNotConnectedState.getInstance(show, comboTimes.getCombo());
        TTraceNotSupportedState.getInstance(show, comboTimes.getCombo());
        TTraceNotOneTargetState.getInstance(show, comboTimes.getCombo());
        TTraceReadyState.getInstance(show, comboTimes.getCombo());
        TTraceWaitingState.getInstance(show, comboTimes.getCombo());
        TTraceAsyncState.getInstance(show, comboTimes.getCombo());
        TTraceDoneState.getInstance(show, comboTimes.getCombo());
        System.out.println("Complete state initiation");
        stateManager.setState(TTraceReadyState.getInstance(show, comboTimes.getCombo()));
        SDBconnection connSdb = SDBconnection.getInstance();
        System.out.println("GetInput: SDBconnection.getInstance");
        connSdb.addDeviceListener();
        CommandHandler.cmdHandler(show, connSdb, env, stateManager);
        String connState = SDBconnection.getState();
        if (connState == "Connected") {
            System.out.println("GetInput: connState == Connected ");
            stateManager.prepareAction();
            show.setText("Ready to trace");
            show.setEnabled(true);
        } else if (connState == "NotConnected") {
            System.out.println("GetInput: connState == NotConnected ");
            MessageDialog.openInformation((Shell)shell, (String)"Connection Failed", (String)"Device is not found, Please connect the device or emulator again");
            show.setText("No Connection");
            show.setEnabled(false);
        } else if (connState == "NotSupported") {
            System.out.println("GetInput: connState == NotSupported ");
            MessageDialog.openInformation((Shell)shell, (String)"Connection Failed", (String)"Device is not compatible, Please check Tizen version on device or emulator, T-trace supports Tizen 2.4 or higher");
            show.setText("Not compatible device");
            show.setEnabled(false);
        } else if (connState == "NotOneTarget") {
            System.out.println("GetInput: connState == NotOneTarget ");
            MessageDialog.openInformation((Shell)shell, (String)"Connection Failed", (String)"Multiple devices or emulators are connected. Please connect only one device or emulator");
            show.setText("Connected multiple devices");
            show.setEnabled(false);
        } else {
            System.out.println("GetInput: Unknown error ");
            MessageDialog.openInformation((Shell)shell, (String)"Unknown error", (String)"Unknown error, Please report to tizen.org");
            show.setText("Unknown error");
            show.setEnabled(false);
        }
        return composite;
    }
}

