/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import ttrace.handlers.Environment;
import ttrace.handlers.SDBconnection;
import ttrace.handlers.State;
import ttrace.handlers.TTraceAsyncState;
import ttrace.handlers.TTraceDoneState;
import ttrace.handlers.TTraceNotConnectedState;
import ttrace.handlers.TTraceReadyState;
import ttrace.handlers.TTraceWaitingState;

class StateManager
implements State {
    private static StateManager stateManager;
    private State state;
    private static boolean isConnected;
    Environment env = Environment.getInstance();
    static Thread asyncThread;
    static Thread syncThread;
    static Thread bootupThread;

    private StateManager() {
    }

    public static StateManager getInstance() {
        System.out.println("StateManager: getInstance()");
        if (stateManager == null) {
            System.out.println("StateManager: new Instance()");
            stateManager = new StateManager();
        }
        return stateManager;
    }

    public static void setBootupThread(Thread thread) {
        bootupThread = thread;
    }

    public static void stopBootupThread() {
        if (bootupThread == null) {
            return;
        }
        if (bootupThread.isAlive()) {
            bootupThread.interrupt();
        }
    }

    public static void setAsyncThread(Thread thread) {
        asyncThread = thread;
    }

    public static void stopAsyncThread() {
        if (asyncThread == null) {
            return;
        }
        if (asyncThread.isAlive()) {
            asyncThread.interrupt();
        }
    }

    public static void setSyncThread(Thread thread) {
        syncThread = thread;
    }

    public static void stopSyncThread() {
        if (syncThread == null) {
            return;
        }
        if (syncThread.isAlive()) {
            syncThread.interrupt();
        }
    }

    void setState(State state) {
        this.state = state;
    }

    @Override
    public String getState() {
        if (this.state == null) {
            this.setState(TTraceReadyState.getInstance());
        }
        return this.state.getState();
    }

    @Override
    public void doAction() {
        System.out.println("doAction::manager");
        this.state.doAction();
        if (SDBconnection.getState() == "NotConnected") {
            this.setState(TTraceNotConnectedState.getInstance());
            this.prepareAction();
            return;
        }
        if (this.state.getState().equals("Ready")) {
            if (this.state.getTimeState().equals("Manual")) {
                this.setState(TTraceAsyncState.getInstance());
                if (!this.state.prepareAction()) {
                    this.setState(TTraceReadyState.getInstance());
                }
            } else {
                this.setState(TTraceWaitingState.getInstance());
                if (!this.state.prepareAction()) {
                    this.setState(TTraceReadyState.getInstance());
                }
                this.state.doAction();
                if (!this.state.getState().equals("Waiting")) {
                    this.prepareAction();
                    return;
                }
                this.setState(TTraceDoneState.getInstance());
                this.state.prepareAction();
            }
        } else if (this.state.getState().equals("Async")) {
            this.setState(TTraceDoneState.getInstance());
            this.state.prepareAction();
        } else if (this.state.getState().equals("Bootup")) {
            this.setState(TTraceDoneState.getInstance());
            this.state.prepareAction();
        } else if (this.state.getState().equals("Done")) {
            this.setState(TTraceReadyState.getInstance());
            this.state.prepareAction(true);
        } else if (this.state.getState().equals("NotSupported")) {
            this.setState(TTraceReadyState.getInstance());
            this.state.prepareAction(true);
        } else if (this.state.getState().equals("NotConnected")) {
            this.setState(TTraceReadyState.getInstance());
            this.state.prepareAction(true);
        } else {
            System.out.println("Wrong state: " + this.state.getState());
        }
    }

    @Override
    public boolean prepareAction() {
        System.out.println("StateManager::prepareAction: State - " + this.state.getState());
        this.state.prepareAction();
        return true;
    }

    @Override
    public boolean prepareAction(boolean isRefresh) {
        System.out.println("StateManager::prepareAction(isRefresh) - " + this.state.getState());
        this.state.prepareAction(isRefresh);
        return true;
    }

    @Override
    public String getTimeState() {
        return null;
    }

    public static String isEnabled(boolean isInit) {
        System.out.println("StateManager: isEnabled");
        if (isInit) {
            return SDBconnection.getState();
        }
        return SDBconnection.getStateRefresh();
    }

    public static void setIsConnected() {
        isConnected = true;
    }

    public static boolean getIsConnected() {
        return isConnected;
    }
}

