/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import ttrace.handlers.CheckboxManager;
import ttrace.handlers.ComboWrapper;

class StringHandler {
    StringHandler() {
    }

    public static void strHandler(final Text srcTextWindow, final Text dstTextWindow, final String typeStr) {
        srcTextWindow.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String str_src = srcTextWindow.getText().toLowerCase();
                String str_dst = dstTextWindow.getText().toLowerCase();
                String str_regex = new String();
                int i = 0;
                while (i < str_src.length()) {
                    if (str_src.charAt(i) < '0' || str_src.charAt(i) > '9') {
                        return;
                    }
                    ++i;
                }
                if (typeStr.equalsIgnoreCase("time")) {
                    str_src = "-t " + str_src + " ";
                    str_regex = "-t [0-9]* ";
                } else if (typeStr.equalsIgnoreCase("buffer")) {
                    str_src = "-b " + str_src + " ";
                    str_regex = "-b [0-9]* ";
                } else {
                    return;
                }
                Pattern p = Pattern.compile(str_regex);
                Matcher m = p.matcher(str_dst);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(sb, str_src);
                }
                m.appendTail(sb);
                dstTextWindow.setText(sb.toString());
            }
        });
    }

    public static void strHandler(Button checkBox, final Text textWindow) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                String str_temp = new String(textWindow.getText());
                str_temp = btn.getSelection() ? String.valueOf(str_temp.toString()) + " " + btn.getText().toLowerCase() : str_temp.replace(" " + btn.getText().toLowerCase(), "");
                textWindow.setText(str_temp.toString());
            }
        });
    }

    public static void strHandler(Button checkBox) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                if (btn.getText().equals("Reset")) {
                    CheckboxManager.clearAllCheckboxes();
                } else {
                    Preferences prefs = Preferences.userRoot().node("ttrace");
                    prefs.putBoolean(btn.getText(), btn.getSelection());
                }
            }
        });
    }

    public static void strHandler(Button checkBox, final ComboWrapper timeCombo, final ComboWrapper sizeCombo) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                if (btn.getText().equals("Reset")) {
                    CheckboxManager.clearAllCheckboxes();
                    timeCombo.setDefault();
                    sizeCombo.setDefault();
                } else {
                    Preferences prefs = Preferences.userRoot().node("ttrace");
                    prefs.putBoolean(btn.getText(), btn.getSelection());
                }
            }
        });
    }

    public static void strHandler(ComboWrapper combo) {
        combo.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                if (btn.getText().equals("Reset")) {
                    CheckboxManager.clearAllCheckboxes();
                } else {
                    Preferences prefs = Preferences.userRoot().node("ttrace");
                    prefs.putBoolean(btn.getText(), btn.getSelection());
                }
            }
        });
    }

    public static void strHandler(Button checkBox, final Text textWindow, final String str) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                String str_temp = new String(textWindow.getText());
                str_temp = btn.getSelection() ? String.valueOf(str_temp.toString()) + " " + str.toLowerCase() : str_temp.replace(" " + str.toLowerCase(), "");
                textWindow.setText(str_temp.toString());
            }
        });
    }

    public static void strHandler(Button checkBox, final Text textWindow, final boolean head) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                String str_temp = new String(textWindow.getText());
                str_temp = !head ? (btn.getSelection() ? String.valueOf(str_temp.toString()) + " " + btn.getText().toLowerCase() : str_temp.replace(" " + btn.getText().toLowerCase(), "")) : (btn.getSelection() ? str_temp.toString().replace("atrace", "atrace --" + btn.getText().toLowerCase()) : str_temp.toString().replace("atrace --" + btn.getText().toLowerCase(), "atrace"));
                textWindow.setText(str_temp.toString());
            }
        });
    }
}

