/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.IOException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import ttrace.handlers.CheckboxManager;
import ttrace.handlers.Environment;
import ttrace.handlers.State;
import ttrace.handlers.StateManager;
import ttrace.handlers.ThreadAsyncTracing;

class TTraceAsyncState
implements State {
    private ThreadAsyncTracing trace;
    private Thread thread;
    private static TTraceAsyncState state;
    private static Button mainButton;
    private static Combo timeCombo;

    private TTraceAsyncState(Button btn, Combo timeCombo) {
        mainButton = btn;
        TTraceAsyncState.timeCombo = timeCombo;
    }

    public static State getInstance() {
        return state;
    }

    public static State getInstance(Button btn, Combo timeCombo) {
        if (state == null) {
            state = new TTraceAsyncState(btn, timeCombo);
        }
        mainButton = btn;
        TTraceAsyncState.timeCombo = timeCombo;
        return state;
    }

    public static void setMainButtonEnable(boolean flag) {
        mainButton.setEnabled(flag);
    }

    @Override
    public void doAction() {
        System.out.println("doAction::Async");
        TTraceAsyncState.setMainButtonEnable(false);
        this.thread.interrupt();
        Environment env = Environment.getInstance();
        env.setStrOutputFilename();
        env.setStrOutputTempFile();
        env.setComposeCmd("--from-file", env.getAsyncTrace());
        System.out.println(env.getComposeCmd());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            ThreadAsyncTracing.composeHtml(env);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TTraceAsyncState.setMainButtonEnable(true);
    }

    @Override
    public boolean prepareAction() {
        System.out.println("prepareAction::Async");
        mainButton.setText("Stop");
        Environment env = Environment.getInstance();
        env.setStartCmd(CheckboxManager.getTags(), true);
        env.setStopCmd(CheckboxManager.getTags(), true);
        env.setDumpCmd(CheckboxManager.getTags(), true);
        env.setPullCmd();
        System.out.println(env.getStartCmd());
        System.out.println(env.getStopCmd());
        System.out.println(env.getDumpCmd());
        System.out.println(env.getPullCmd());
        this.trace = new ThreadAsyncTracing();
        this.thread = new Thread(this.trace);
        StateManager.setAsyncThread(this.thread);
        this.thread.start();
        return true;
    }

    @Override
    public String getState() {
        return "Async";
    }

    @Override
    public String getTimeState() {
        return timeCombo.getText();
    }

    @Override
    public boolean prepareAction(boolean isRefresh) {
        return false;
    }
}

